/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.divxdede.swing.busy.DefaultBusyModel;

public class FutureBusyModel
extends DefaultBusyModel {
    private ExecutorService service = null;
    private int ticket = 0;
    private Future trackedFuture = null;
    private Future trackerFuture = null;

    public synchronized void setFuture(Future future) {
        this.setFuture(future, true);
    }

    public void setBusy(boolean value) {
        this.setBusyImpl(value);
    }

    private synchronized int setBusyImpl(boolean value) {
        super.setBusy(value);
        return ++this.ticket;
    }

    private synchronized boolean compareAndSetBusy(boolean value, int ticketValue) {
        if (ticketValue == this.ticket) {
            this.setBusy(value);
            return true;
        }
        return false;
    }

    public synchronized void setFuture(Future future, boolean cancellable) {
        if (this.service == null) {
            this.service = Executors.newSingleThreadExecutor();
        }
        if (future == null) {
            return;
        }
        this.trackedFuture = future;
        if (this.trackerFuture != null) {
            this.trackerFuture.cancel(true);
        }
        this.trackerFuture = null;
        this.setDeterminate(false);
        this.setCancellable(cancellable);
        Runnable tracker = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int myTicket = 0;
                try {
                    Future myFuture = FutureBusyModel.this.trackedFuture;
                    while (!myFuture.isDone()) {
                        myTicket = FutureBusyModel.this.setBusyImpl(true);
                        try {
                            myFuture.get();
                        }
                        catch (Exception e) {
                            if (myFuture == FutureBusyModel.this.trackedFuture) continue;
                            break;
                        }
                    }
                }
                finally {
                    FutureBusyModel.this.compareAndSetBusy(false, myTicket);
                }
            }
        };
        this.trackerFuture = this.service.submit(tracker);
    }

    public synchronized void cancel() {
        Future toCancel = this.trackedFuture;
        if (toCancel != null) {
            toCancel.cancel(true);
        }
        this.trackedFuture = null;
        this.trackerFuture = null;
    }
}

