/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import org.divxdede.swing.busy.BusyModel;

public class DefaultBusyModel
extends DefaultBoundedRangeModel
implements BusyModel {
    private boolean busyState = false;
    private boolean determinateState = false;
    private boolean autoCompletionState = false;
    private boolean cancellableState = false;
    private String description = null;

    public void setBusy(boolean value) {
        boolean oldValue = this.isBusy();
        this.busyState = value;
        if (oldValue != this.isBusy()) {
            if (this.isBusy() && this.isDeterminate() && this.isAutoCompletionEnabled()) {
                this.setValue(this.getMinimum());
            }
            this.fireStateChanged();
        }
    }

    public boolean isBusy() {
        return this.busyState;
    }

    public void setValue(int n) {
        super.setValue(n);
        if (this.isDeterminate() && this.isAutoCompletionEnabled() && this.getValue() >= this.getMaximum()) {
            this.setBusy(false);
        }
    }

    public void setDeterminate(boolean value) {
        boolean oldValue = this.isDeterminate();
        this.determinateState = value;
        if (oldValue != this.isDeterminate()) {
            this.fireStateChanged();
        }
    }

    public boolean isDeterminate() {
        return this.determinateState;
    }

    public void setAutoCompletionEnabled(boolean value) {
        boolean oldValue = this.isAutoCompletionEnabled();
        this.autoCompletionState = value;
        if (oldValue != this.isAutoCompletionEnabled()) {
            this.fireStateChanged();
        }
    }

    public boolean isAutoCompletionEnabled() {
        return this.autoCompletionState;
    }

    public boolean isCancellable() {
        return this.cancellableState;
    }

    public void cancel() {
        if (!this.isCancellable()) {
            throw new IllegalStateException("this model is not cancellable");
        }
        this.setBusy(false);
    }

    public void setCancellable(boolean value) {
        boolean oldValue = this.isCancellable();
        this.cancellableState = value;
        if (oldValue != this.isCancellable()) {
            this.fireStateChanged();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        String old = s;
        this.description = s;
        if (old != this.description) {
            if (old != null && this.description != null && old.equals(this.description)) {
                return;
            }
            this.fireStateChanged();
        }
    }

    protected void fireStateChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable doRun = new Runnable(){

                public void run() {
                    DefaultBusyModel.this.fireStateChanged();
                }
            };
            SwingUtilities.invokeLater(doRun);
            return;
        }
        super.fireStateChanged();
    }
}

