/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing;

import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.collection.CyclicBuffer;
import org.divxdede.commons.Disposable;

public class RemainingTimeMonitor
implements Disposable {
    private BoundedRangeModel model = null;
    private int bulkDelay = 500;
    private CyclicBuffer<Float> bulks = null;
    private long bulkStartTime = 0L;
    private float bulkStartRatio = 0.0f;
    private ChangeListener listener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            RemainingTimeMonitor.this.tick(true);
        }
    };

    public RemainingTimeMonitor(BoundedRangeModel model) {
        this(model, 500, 10);
    }

    public RemainingTimeMonitor(BoundedRangeModel model, int samplePeriodDelay, int sampleCount) {
        this.model = model;
        this.bulkDelay = samplePeriodDelay;
        this.bulks = new CyclicBuffer(sampleCount);
        this.model.addChangeListener(this.listener);
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    private synchronized void tick(boolean starteable) {
        if (this.bulkStartTime == 0L) {
            if (!starteable) {
                return;
            }
            this.bulkStartTime = System.currentTimeMillis();
            this.bulkStartRatio = RemainingTimeMonitor.getRatio(this.getModel());
            return;
        }
        long currentTime = System.currentTimeMillis();
        long delay = currentTime - this.bulkStartTime;
        if (delay > (long)this.bulkDelay) {
            float normalization_factor = (float)this.bulkDelay / (float)delay;
            float currentRatio = RemainingTimeMonitor.getRatio(this.getModel());
            float bulkAdvance = (currentRatio - this.bulkStartRatio) * normalization_factor;
            this.bulks.add((Object)Float.valueOf(bulkAdvance));
            this.bulkStartTime = currentTime;
            this.bulkStartRatio = currentRatio;
            if (this.getModel().getValue() + this.getModel().getExtent() >= this.getModel().getMaximum()) {
                this.dispose();
            }
        }
    }

    public void dispose() {
        if (this.listener != null) {
            this.getModel().removeChangeListener(this.listener);
            this.listener = null;
        }
    }

    public long getRemainingTime(TimeUnit unit) {
        return unit.convert(this.getRemainingTime(), TimeUnit.MILLISECONDS);
    }

    public synchronized long getRemainingTime() {
        this.tick(false);
        if (this.bulks.isEmpty()) {
            return -1L;
        }
        float currentRatio = RemainingTimeMonitor.getRatio(this.getModel());
        if (currentRatio >= 1.0f) {
            return 0L;
        }
        float advance = 0.0f;
        long time = 0L;
        for (int i = 0; i < this.bulks.size(); ++i) {
            advance += ((Float)this.bulks.get(i)).floatValue();
            time += (long)this.bulkDelay;
        }
        float remainingRatio = 1.0f - currentRatio;
        if (advance == 0.0f) {
            return -1L;
        }
        return (long)(1.0f / advance * (float)time * remainingRatio);
    }

    public static float getRatio(BoundedRangeModel brm) {
        if (brm != null) {
            int length = brm.getMaximum() - brm.getMinimum();
            int value = brm.getValue() + brm.getExtent();
            return (float)value / (float)length;
        }
        return 0.0f;
    }
}

