/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.collection.ArrayIterator;
import org.divxdede.commons.Disposable;
import org.divxdede.commons.Sizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedRangeModelHub
implements ChangeListener,
Iterable<BoundedRangeModel>,
Sizable,
Disposable {
    private List<WeightBoundedRangeModel> subs = new ArrayList<WeightBoundedRangeModel>();
    private BoundedRangeModel master = null;
    private float totalWeight = 0.0f;
    private boolean changing = false;

    public BoundedRangeModelHub() {
        this(null);
    }

    public BoundedRangeModelHub(BoundedRangeModel master) {
        this.setMasterBoundedRangeModel(master);
    }

    public synchronized void setMasterBoundedRangeModel(BoundedRangeModel model) {
        BoundedRangeModel oldMaster = this.master;
        if (oldMaster != null) {
            oldMaster.removeChangeListener(this);
        }
        this.master = model;
        if (this.master == null) {
            for (WeightBoundedRangeModel sub : this.subs) {
                sub.getModel().removeChangeListener(this);
            }
        } else {
            this.master.addChangeListener(this);
            if (oldMaster == null) {
                for (WeightBoundedRangeModel sub : this.subs) {
                    sub.getModel().addChangeListener(this);
                }
            }
        }
        if (oldMaster != this.master) {
            this.stateChanged(null);
        }
    }

    public synchronized BoundedRangeModel getMasterBoundedRangeModel() {
        return this.master;
    }

    public synchronized BoundedRangeModel createFragment(float weight) {
        return this.addFragment(new DefaultBoundedRangeModel(), weight);
    }

    public synchronized BoundedRangeModel addFragment(BoundedRangeModel fragment, float weight) {
        if (fragment == null) {
            throw new NullPointerException();
        }
        if (weight < 0.0f) {
            throw new IllegalArgumentException("weight must be positive");
        }
        WeightBoundedRangeModel splitted = new WeightBoundedRangeModel(fragment, weight);
        if (this.master != null) {
            splitted.getModel().addChangeListener(this);
        }
        this.subs.add(splitted);
        this.totalWeight += weight;
        this.stateChanged(null);
        return splitted.getModel();
    }

    public synchronized BoundedRangeModel removeFragment(int index) {
        WeightBoundedRangeModel splitted = this.subs.remove(index);
        if (splitted != null) {
            splitted.getModel().removeChangeListener(this);
            this.totalWeight -= splitted.getWeight();
            this.stateChanged(null);
            return splitted.getModel();
        }
        return null;
    }

    public synchronized BoundedRangeModel[] getFragments() {
        BoundedRangeModel[] result = new BoundedRangeModel[this.subs.size()];
        for (int i = 0; i < this.subs.size(); ++i) {
            result[i] = this.subs.get(i).getModel();
        }
        return result;
    }

    @Override
    public synchronized Iterator<BoundedRangeModel> iterator() {
        return new ArrayIterator((Object[])this.getFragments());
    }

    public synchronized int size() {
        return this.subs.size();
    }

    public synchronized int indexOf(BoundedRangeModel model) {
        for (int i = 0; i < this.subs.size(); ++i) {
            if (model != this.subs.get(i).getModel()) continue;
            return i;
        }
        return -1;
    }

    public synchronized BoundedRangeModel getFragment(int index) {
        return this.subs.get(index).getModel();
    }

    public synchronized float getWeight(int index) {
        return this.subs.get(index).getWeight();
    }

    public synchronized void setWeight(int index, float newWeight) {
        if (newWeight < 0.0f) {
            throw new IllegalArgumentException("Weight must be positive");
        }
        float oldWeight = this.getWeight(index);
        this.subs.get(index).setWeight(newWeight);
        this.totalWeight = this.totalWeight - oldWeight + newWeight;
        this.stateChanged(null);
    }

    public synchronized float getTotalWeight() {
        return this.totalWeight;
    }

    public void dispose() {
        this.setMasterBoundedRangeModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stateChanged(ChangeEvent e) {
        if (this.changing) {
            return;
        }
        this.changing = true;
        try {
            if (this.getMasterBoundedRangeModel() == null) {
                return;
            }
            int extent = 0;
            for (WeightBoundedRangeModel sub : this.subs) {
                extent += sub.getExtentPartFor(this.getTotalWeight(), this.getMasterBoundedRangeModel());
            }
            this.getMasterBoundedRangeModel().setValue(extent);
        }
        finally {
            this.changing = false;
        }
    }

    public static BoundedRangeModelHub split(BoundedRangeModel toSplit, int length) {
        float[] weights = new float[length];
        for (int i = 0; i < length; ++i) {
            weights[i] = 1.0f;
        }
        return BoundedRangeModelHub.split(toSplit, weights);
    }

    public static BoundedRangeModelHub split(BoundedRangeModel toSplit, Number ... weights) {
        float[] fWeight = new float[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            fWeight[i] = weights[i].floatValue();
        }
        return BoundedRangeModelHub.split(toSplit, fWeight);
    }

    public static BoundedRangeModelHub split(BoundedRangeModel toSplit, float ... weights) {
        if (weights == null) {
            return null;
        }
        BoundedRangeModelHub hub = new BoundedRangeModelHub(toSplit);
        for (int i = 0; i < weights.length; ++i) {
            hub.createFragment(weights[i]);
        }
        return hub;
    }

    private static class WeightBoundedRangeModel {
        private BoundedRangeModel model = null;
        private float weight = 0.0f;

        private WeightBoundedRangeModel(BoundedRangeModel model, float weight) {
            this.model = model;
            this.weight = weight;
        }

        public int getExtentPartFor(float totalWeight, BoundedRangeModel other) {
            int length = this.getModel().getMaximum() - this.getModel().getMinimum();
            int position = this.getModel().getValue() + this.getModel().getExtent() - this.getModel().getMinimum();
            float ratio = (float)position / (float)length;
            int otherLength = other.getMaximum() - other.getMinimum() - other.getExtent();
            float otherRatio = ratio * (this.weight / totalWeight);
            return (int)((float)otherLength * otherRatio);
        }

        private float getWeight() {
            return this.weight;
        }

        private void setWeight(float newWeight) {
            this.weight = newWeight;
        }

        public BoundedRangeModel getModel() {
            return this.model;
        }
    }
}

