/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.mkldnn;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nd4j.linalg.factory.Nd4j;

public class BaseMKLDNNHelper {
    private static AtomicBoolean BACKEND_OK = null;
    private static AtomicBoolean FAILED_CHECK = null;

    public static boolean mklDnnEnabled() {
        if (BACKEND_OK == null) {
            String backend = Nd4j.getExecutioner().getEnvironmentInformation().getProperty("backend");
            BACKEND_OK = new AtomicBoolean("CPU".equalsIgnoreCase(backend));
        }
        if (!BACKEND_OK.get() || FAILED_CHECK != null && FAILED_CHECK.get()) {
            return false;
        }
        if (!Nd4j.getEnvironment().helpersAllowed()) {
            return false;
        }
        try {
            Class<?> c = Class.forName("org.nd4j.nativeblas.Nd4jCpu$Environment");
            Method m = c.getMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            Method m2 = c.getMethod("isUseMKLDNN", new Class[0]);
            boolean b = (Boolean)m2.invoke(instance, new Object[0]);
            return b;
        }
        catch (Throwable t) {
            FAILED_CHECK = new AtomicBoolean(true);
            return false;
        }
    }
}

