/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.wiki;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.debux.webmotion.server.WebMotionFilter;
import org.debux.webmotion.server.call.HttpContext;
import org.debux.webmotion.server.render.Render;
import org.debux.webmotion.wiki.Security;
import org.debux.webmotion.wiki.service.WikiConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Security
extends WebMotionFilter {
    private static final Logger log = LoggerFactory.getLogger(Security.class);
    public static final String CURRENT_USER_ATTRIBUTE = "current_user";
    public static final String NO_SECURE = "no-secure";
    protected List<User> users;
    protected Map<String, String> permissions;

    public Security() throws IOException, URISyntaxException {
        String usersPath = WikiConfig.instance.getUsersPath();
        FileInputStream stream = new FileInputStream(usersPath);
        String json = IOUtils.toString((InputStream)stream);
        Gson gson = new Gson();
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.users = (List)gson.fromJson(json, listType);
        this.permissions = new HashMap();
        this.permissions.put("login", NO_SECURE);
        this.permissions.put("logout", NO_SECURE);
        this.permissions.put("language", NO_SECURE);
        this.permissions.put(null, "read");
        this.permissions.put("include", "read");
        this.permissions.put("sitemap", "read");
        this.permissions.put("mediamap", "read");
        this.permissions.put("first", "read");
        this.permissions.put("source", "write");
        this.permissions.put("delete", "write");
        this.permissions.put("create", "write");
        this.permissions.put("save", "write");
        this.permissions.put("preview", "write");
        this.permissions.put("edit", "write");
        this.permissions.put("attach", "write");
        this.permissions.put("upload", "write");
    }

    public Render login(String username, String password) throws Exception {
        for (User user : this.users) {
            String name = user.getName();
            if (!name.equals(username)) continue;
            String encoded = DigestUtils.shaHex((String)password);
            log.debug("encoded = " + encoded);
            if (encoded.equals(user.getPassword())) {
                HttpContext context = this.getContext();
                HttpSession session = context.getSession();
                session.setAttribute(CURRENT_USER_ATTRIBUTE, (Object)user);
                return this.renderURL("/", new Object[0]);
            }
            return this.renderURL("/login", new Object[]{"error.login", "password"});
        }
        return this.renderURL("/login", new Object[]{"error.login", "username"});
    }

    public Render logout(String login, String password) throws Exception {
        HttpContext context = this.getContext();
        HttpSession session = context.getSession();
        session.removeAttribute(CURRENT_USER_ATTRIBUTE);
        return this.renderLastPage(new Object[0]);
    }

    public Render check(String action, String sub) throws Exception {
        String[] publicPermissions = WikiConfig.instance.getPublicPermissions();
        List<String> currentPermissions = Arrays.asList(publicPermissions);
        HttpContext context = this.getContext();
        HttpSession session = context.getSession();
        User user = (User)session.getAttribute(CURRENT_USER_ATTRIBUTE);
        if (user != null) {
            List roles = user.getRoles();
            currentPermissions.addAll(roles);
        }
        String required = action != null ? (String)this.permissions.get(action) : (String)this.permissions.get(sub);
        log.debug("required = " + required + " in " + currentPermissions);
        if (required != null && (required.equals(NO_SECURE) || currentPermissions.contains(required))) {
            this.doProcess();
            return null;
        }
        return this.renderURL("/login", new Object[0]);
    }
}

