/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.datavec.api.writable.ArrayWritable;
import org.datavec.api.writable.WritableType;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.factory.Nd4j;

public class BytesWritable
extends ArrayWritable {
    private byte[] content;
    private transient ByteBuffer cached;

    public BytesWritable(byte[] content) {
        this.content = content;
    }

    public DataBuffer asNd4jBuffer(DataType type, int elementSize) {
        int length = this.content.length / elementSize;
        DataBuffer ret = Nd4j.createBuffer((ByteBuffer)ByteBuffer.allocateDirect(this.content.length), (DataType)type, (int)length, (long)0L);
        block6: for (int i = 0; i < length; ++i) {
            switch (type) {
                case DOUBLE: {
                    ret.put((long)i, this.getDouble(i));
                    continue block6;
                }
                case INT: {
                    ret.put((long)i, this.getInt(i));
                    continue block6;
                }
                case FLOAT: {
                    ret.put((long)i, this.getFloat(i));
                    continue block6;
                }
                case LONG: {
                    ret.put((long)i, this.getLong(i));
                }
            }
        }
        return ret;
    }

    @Override
    public long length() {
        return this.content.length;
    }

    @Override
    public double getDouble(long i) {
        return this.cachedByteByteBuffer().getDouble((int)i * 8);
    }

    @Override
    public float getFloat(long i) {
        return this.cachedByteByteBuffer().getFloat((int)i * 4);
    }

    @Override
    public int getInt(long i) {
        return this.cachedByteByteBuffer().getInt((int)i * 4);
    }

    @Override
    public long getLong(long i) {
        return this.cachedByteByteBuffer().getLong((int)i * 8);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.content);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        in.readFully(this.content);
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        out.writeShort(this.getType().typeIdx());
    }

    @Override
    public WritableType getType() {
        return WritableType.Bytes;
    }

    private ByteBuffer cachedByteByteBuffer() {
        if (this.cached == null) {
            this.cached = ByteBuffer.wrap(this.content);
        }
        return this.cached;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesWritable that = (BytesWritable)o;
        return Arrays.equals(this.content, that.content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }

    public BytesWritable() {
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }
}

