/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.converters;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.cyclonedx.model.LicenseText;

public class LicenseTextConverter
implements Converter {
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        LicenseText licenseText = (LicenseText)object;
        writer.addAttribute("content-type", licenseText.getContentType());
        writer.addAttribute("encoding", licenseText.getEncoding());
        writer.setValue(licenseText.getText());
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(LicenseText.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String contentType = reader.getAttribute("content-type");
        String encoding = reader.getAttribute("encoding");
        String text = reader.getValue();
        LicenseText licenseText = new LicenseText();
        licenseText.setContentType(contentType);
        licenseText.setEncoding(encoding);
        licenseText.setText(text);
        return licenseText;
    }
}

