/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cyclonedx.AbstractBomGenerator;
import org.cyclonedx.BomGenerator;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.model.Attribute;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Commit;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.IdentifiableActionType;
import org.cyclonedx.model.Pedigree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BomGenerator11
extends AbstractBomGenerator
implements BomGenerator {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Bom bom;

    BomGenerator11(Bom bom) {
        this.bom = bom;
    }

    @Override
    public CycloneDxSchema.Version getSchemaVersion() {
        return CycloneDxSchema.Version.VERSION_11;
    }

    @Override
    public Document generate() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.doc.setXmlStandalone(true);
        Element bomNode = this.createRootElement("bom", null, new Attribute("xmlns", "http://cyclonedx.org/schema/bom/1.1"), new Attribute("version", String.valueOf(this.bom.getVersion())));
        if (this.bom.getSerialNumber() != null) {
            bomNode.setAttribute("serialNumber", this.bom.getSerialNumber());
        }
        Element componentsNode = this.createElement(bomNode, "components");
        this.createComponentsNode(componentsNode, this.bom.getComponents());
        this.createExternalReferencesNode(bomNode, this.bom.getExternalReferences());
        return this.doc;
    }

    private void createComponentsNode(Node parent, List<Component> components) {
        if (components != null && !components.isEmpty()) {
            for (Component component : components) {
                Element componentNode = this.createElement(parent, "component", null, new Attribute("type", component.getType().getTypeName()));
                this.createElement(componentNode, "publisher", BomGenerator11.stripBreaks(component.getPublisher()));
                this.createElement(componentNode, "group", BomGenerator11.stripBreaks(component.getGroup()));
                this.createElement(componentNode, "name", BomGenerator11.stripBreaks(component.getName()));
                this.createElement(componentNode, "version", BomGenerator11.stripBreaks(component.getVersion()));
                this.createElement(componentNode, "description", BomGenerator11.stripBreaks(component.getDescription()));
                if (component.getScope() == null) {
                    this.createElement(componentNode, "scope", Component.Scope.REQUIRED.getScopeName());
                } else {
                    this.createElement(componentNode, "scope", component.getScope().getScopeName());
                }
                this.createHashesNode(componentNode, component.getHashes());
                this.createLicenseNode(componentNode, component.getLicenseChoice(), true);
                this.createElement(componentNode, "copyright", BomGenerator11.stripBreaks(component.getCopyright()));
                this.createElement(componentNode, "cpe", BomGenerator11.stripBreaks(component.getCpe()));
                this.createElement(componentNode, "purl", BomGenerator11.stripBreaks(component.getPurl()));
                this.createPedigreeNode(componentNode, component.getPedigree());
                this.createExternalReferencesNode(componentNode, component.getExternalReferences());
                if (component.getComponents() == null || component.getComponents().isEmpty()) continue;
                Element subComponentsNode = this.createElement(componentNode, "components");
                this.createComponentsNode(subComponentsNode, component.getComponents());
            }
        }
    }

    private void createPedigreeNode(Node parent, Pedigree pedigree) {
        if (pedigree != null) {
            Element pedigreeNode = this.createElement(parent, "pedigree");
            if (pedigree.getAncestors() != null && !pedigree.getAncestors().isEmpty()) {
                Element ancestorsNode = this.createElement(pedigreeNode, "ancestors");
                this.createComponentsNode(ancestorsNode, pedigree.getAncestors());
            }
            if (pedigree.getDescendants() != null && !pedigree.getDescendants().isEmpty()) {
                Element descendantsNode = this.createElement(pedigreeNode, "descendants");
                this.createComponentsNode(descendantsNode, pedigree.getDescendants());
            }
            if (pedigree.getVariants() != null && !pedigree.getVariants().isEmpty()) {
                Element variantsNode = this.createElement(pedigreeNode, "variants");
                this.createComponentsNode(variantsNode, pedigree.getVariants());
            }
            if (pedigree.getCommits() != null && !pedigree.getCommits().isEmpty()) {
                Element commitsNode = this.createElement(pedigreeNode, "commits");
                this.createCommitsNode(commitsNode, pedigree.getCommits());
            }
            this.createElement(pedigreeNode, "notes", BomGenerator11.stripBreaks(pedigree.getNotes()));
        }
    }

    private void createCommitsNode(Node parent, List<Commit> commits) {
        if (commits != null) {
            for (Commit commit : commits) {
                Element commitNode = this.createElement(parent, "commit");
                this.createElement(commitNode, "uid", BomGenerator11.stripBreaks(commit.getUid()));
                this.createElement(commitNode, "url", BomGenerator11.stripBreaks(commit.getUrl()));
                this.createActorNode(commitNode, "author", commit.getAuthor());
                this.createActorNode(commitNode, "committer", commit.getCommitter());
                this.createElement(commitNode, "message", BomGenerator11.stripBreaks(commit.getMessage()));
            }
        }
    }

    private void createActorNode(Node parent, String nodeName, IdentifiableActionType actor) {
        if (actor != null) {
            Element authorNode = this.createElement(parent, nodeName);
            if (actor.getTimestamp() != null) {
                this.createElement(authorNode, "timestamp", this.dateFormat.format(actor.getTimestamp()));
            }
            this.createElement(authorNode, "name", BomGenerator11.stripBreaks(actor.getName()));
            this.createElement(authorNode, "email", BomGenerator11.stripBreaks(actor.getEmail()));
        }
    }

    private void createExternalReferencesNode(Node parent, List<ExternalReference> references) {
        if (references != null && !references.isEmpty()) {
            Element externalReferencesNode = this.createElement(parent, "externalReferences");
            for (ExternalReference reference : references) {
                if (reference.getType() == null) continue;
                Element referenceNode = this.createElement(externalReferencesNode, "reference", null, new Attribute("type", reference.getType().getTypeName()));
                this.createElement(referenceNode, "url", BomGenerator11.stripBreaks(reference.getUrl()));
                this.createElement(referenceNode, "comment", BomGenerator11.stripBreaks(reference.getUrl()));
            }
        }
    }
}

