/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cyclonedx.AbstractBomGenerator;
import org.cyclonedx.BomGenerator;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.model.Attribute;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BomGenerator10
extends AbstractBomGenerator
implements BomGenerator {
    private final Bom bom;

    BomGenerator10(Bom bom) {
        this.bom = bom;
    }

    @Override
    public CycloneDxSchema.Version getSchemaVersion() {
        return CycloneDxSchema.Version.VERSION_10;
    }

    @Override
    public Document generate() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.doc.setXmlStandalone(true);
        Element bomNode = this.createRootElement("bom", null, new Attribute("xmlns", "http://cyclonedx.org/schema/bom/1.0"), new Attribute("version", "1"));
        Element componentsNode = this.createElement(bomNode, "components");
        this.createComponentsNode(componentsNode, this.bom.getComponents());
        return this.doc;
    }

    private void createComponentsNode(Node parent, List<Component> components) {
        if (components != null && !components.isEmpty()) {
            for (Component component : components) {
                Element componentNode = this.createElement(parent, "component", null, new Attribute("type", component.getType().getTypeName()));
                this.createElement(componentNode, "publisher", BomGenerator10.stripBreaks(component.getPublisher()));
                this.createElement(componentNode, "group", BomGenerator10.stripBreaks(component.getGroup()));
                this.createElement(componentNode, "name", BomGenerator10.stripBreaks(component.getName()));
                this.createElement(componentNode, "version", BomGenerator10.stripBreaks(component.getVersion()));
                this.createElement(componentNode, "description", BomGenerator10.stripBreaks(component.getDescription()));
                if (component.getScope() == null) {
                    this.createElement(componentNode, "scope", Component.Scope.REQUIRED.getScopeName());
                } else if (component.getScope() != Component.Scope.EXCLUDED) {
                    this.createElement(componentNode, "scope", component.getScope().getScopeName());
                }
                this.createHashesNode(componentNode, component.getHashes());
                this.createLicenseNode(componentNode, component.getLicenseChoice(), false);
                this.createElement(componentNode, "copyright", BomGenerator10.stripBreaks(component.getCopyright()));
                this.createElement(componentNode, "cpe", BomGenerator10.stripBreaks(component.getCpe()));
                this.createElement(componentNode, "purl", BomGenerator10.stripBreaks(component.getPurl()));
                this.createElement(componentNode, "modified", String.valueOf(component.isModified()));
                if (component.getComponents() == null || component.getComponents().isEmpty()) continue;
                Element subComponentsNode = this.createElement(componentNode, "components");
                this.createComponentsNode(subComponentsNode, component.getComponents());
            }
        }
    }
}

