/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.shallowparser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import opennlp.tools.chunker.DefaultChunkerSequenceValidator;
import org.cogroo.tools.featurizer.WordTag;

public class ShallowParserSequenceValidator
extends DefaultChunkerSequenceValidator {
    private static final Set<String> PRONOMES_OBLIQUOS;

    public boolean validSequence(int i, WordTag[] inputSequence, String[] outcomesSequence, String outcome) {
        boolean isValid = this.validOutcome(outcome, outcomesSequence);
        isValid = isValid && this.validateNested(i, inputSequence, outcomesSequence, outcome);
        isValid = isValid && this.validateSubj(i, inputSequence, outcomesSequence, outcome);
        return isValid;
    }

    private boolean validateSubj(int i, WordTag[] inputSequence, String[] outcomesSequence, String outcome) {
        if (i > 0) {
            if (outcomesSequence[i - 1].equals("B-SUBJ") && !outcome.equals("I-SUBJ") && (inputSequence[i - 1].getPostag().startsWith("art") || this.isPronObli(inputSequence[i - 1]))) {
                return false;
            }
            if (outcomesSequence[i - 1].endsWith("SUBJ") && !outcome.endsWith("SUBJ") && inputSequence[i - 1].getPostag().equals(",")) {
                return false;
            }
        }
        return true;
    }

    private boolean isPronObli(WordTag wordTag) {
        return PRONOMES_OBLIQUOS.contains(wordTag.getWord().toLowerCase()) && this.extractPOS(wordTag.getPostag()).equals("pron-pers");
    }

    private boolean validateNested(int i, WordTag[] inputSequence, String[] outcomesSequence, String outcome) {
        String chunk;
        String previousChunk;
        if (i > 0 && this.isContinuation(previousChunk = this.extractChunk(inputSequence[i - 1].getPostag()), chunk = this.extractChunk(inputSequence[i].getPostag()))) {
            if (this.isOther(outcomesSequence[i - 1], outcome)) {
                return true;
            }
            if (!this.isContinuation(outcomesSequence[i - 1], outcome)) {
                return false;
            }
        }
        return true;
    }

    private boolean isOther(String a, String b) {
        return "O".equals(a) && "O".equals(b);
    }

    private boolean isContinuation(String a, String b) {
        return (a.startsWith("B-") || a.startsWith("I-")) && b.startsWith("I-");
    }

    private String extractChunk(String postag) {
        int i = postag.indexOf(124);
        return postag.substring(i + 1);
    }

    private String extractPOS(String postag) {
        int i = postag.indexOf(124);
        return postag.substring(0, i);
    }

    static {
        String[] pronomes_obliq = new String[]{"me", "te", "nos", "vos", "o", "os", "a", "as", "lhe", "lhes", "mim", "ti", "comigo", "contigo", "conosco", "convosco", "consigo", "s\u00ed"};
        PRONOMES_OBLIQUOS = new HashSet<String>(Arrays.asList(pronomes_obliq));
    }
}

