/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.postag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import org.cogroo.dictionary.impl.FSADictionary;
import org.cogroo.tools.postag.PortugueseExFactory;
import org.cogroo.util.serializers.ByteArraySerializer;

public class FSAPortugueseFactory
extends PortugueseExFactory {
    private static final String FSA_POSDICT_SUF = "fsa_data";
    private static final String FSA_DICT_INFO_SUF = "fsa_info";
    private static final String FSA_POSDICT = "dict.fsa_data";
    private static final String FSA_DICT_INFO = "dict.fsa_info";
    private TagDictionary dict;
    private byte[] dictInfo;
    private byte[] dictData;

    public FSAPortugueseFactory() {
    }

    public FSAPortugueseFactory(Dictionary ngramDictionary, TagDictionary posDictionary) {
        super(ngramDictionary, null);
    }

    protected void init(Dictionary ngramDictionary, TagDictionary posDictionary) {
        super.init(ngramDictionary, null);
        this.dict = posDictionary;
        String path = System.getProperty("fsa.dict");
        if (path == null) {
            throw new IllegalArgumentException("The property fsa.dict is missing! -Dfsa.dict=path");
        }
        try {
            this.dictInfo = FSADictionary.getFSADictionaryInfo(path);
            this.dictData = FSADictionary.getFSADictionaryData(path);
            this.dict = FSADictionary.create(this.dictData, this.dictInfo);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The file is not a FSA dictionary!", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open the FSA dictionary or the .info file", e);
        }
    }

    @Override
    public TagDictionary getTagDictionary() {
        Object obj;
        if (this.dict == null && this.artifactProvider != null && (obj = this.artifactProvider.getArtifact(FSA_POSDICT)) != null) {
            byte[] data = (byte[])this.artifactProvider.getArtifact(FSA_POSDICT);
            byte[] info = (byte[])this.artifactProvider.getArtifact(FSA_DICT_INFO);
            try {
                this.dict = FSADictionary.create(data, info);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.dict;
    }

    public void setTagDictionary(TagDictionary dictionary) {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    public TagDictionary createEmptyTagDictionary() {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    public TagDictionary createTagDictionary(File dictionary) throws InvalidFormatException, FileNotFoundException, IOException {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    @Override
    public TagDictionary createTagDictionary(InputStream in) throws InvalidFormatException, IOException {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        serializers.put(FSA_POSDICT_SUF, new ByteArraySerializer());
        serializers.put(FSA_DICT_INFO_SUF, new ByteArraySerializer());
        return serializers;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        artifactMap.put(FSA_POSDICT, this.dictData);
        artifactMap.put(FSA_DICT_INFO, this.dictInfo);
        return artifactMap;
    }
}

