/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.postag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.InvalidFormatException;
import org.cogroo.dictionary.impl.FSADictionary;
import org.cogroo.tools.postag.PortugueseExFactory;

public class ExtDictFSAPortugueseFactory
extends PortugueseExFactory {
    private static final String FSA_POSDICT_SUF = "fsa_data";
    private static final String FSA_DICT_INFO_SUF = "fsa_info";
    private static final String FSA_POSDICT = "dict.fsa_data";
    private static final String FSA_DICT_INFO = "dict.fsa_info";
    private TagDictionary dict;

    public ExtDictFSAPortugueseFactory() {
    }

    public ExtDictFSAPortugueseFactory(Dictionary ngramDictionary, TagDictionary posDictionary) {
        super(ngramDictionary, null);
    }

    protected void init(Dictionary ngramDictionary, TagDictionary posDictionary) {
        super.init(ngramDictionary, null);
        this.dict = posDictionary;
        String path = System.getProperty("fsa.dict");
        if (path == null) {
            throw new IllegalArgumentException("The property fsa.dict is missing! -Dfsa.dict=path");
        }
        try {
            InputStream dict = ((Object)((Object)this)).getClass().getResourceAsStream(path + ".dict");
            InputStream info = ((Object)((Object)this)).getClass().getResourceAsStream(path + ".info");
            if (dict == null) {
                System.out.println("NULLL");
            }
            this.dict = FSADictionary.create(dict, info);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The file is not a FSA dictionary!", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open the FSA dictionary or the .info file", e);
        }
    }

    @Override
    public TagDictionary getTagDictionary() {
        if (this.dict == null) {
            String path = "/fsa_dictionaries/pos/pt_br_jspell_corpus";
            InputStream dict = ((Object)((Object)this)).getClass().getResourceAsStream(path + ".dict");
            InputStream info = ((Object)((Object)this)).getClass().getResourceAsStream(path + ".info");
            try {
                this.dict = FSADictionary.create(dict, info);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.dict;
    }

    public void setTagDictionary(TagDictionary dictionary) {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    public TagDictionary createEmptyTagDictionary() {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    public TagDictionary createTagDictionary(File dictionary) throws InvalidFormatException, FileNotFoundException, IOException {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }

    @Override
    public TagDictionary createTagDictionary(InputStream in) throws InvalidFormatException, IOException {
        throw new UnsupportedOperationException("FSA factory does not support this operation");
    }
}

