/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.TokenTag;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.tools.featurizer.DefaultFeaturizerFactory;
import org.cogroo.tools.featurizer.FeaturizerFactory;

public class FeaturizerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "FeaturizerME";
    public static final String FEATURIZER_MODEL_ENTRY_NAME = "featurizer.model";

    public FeaturizerModel(String languageCode, MaxentModel featurizerModel, Map<String, String> manifestInfoEntries, FeaturizerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, (BaseToolFactory)factory);
        if (featurizerModel == null) {
            throw new IllegalArgumentException("The featurizerModel param must not be null!");
        }
        this.artifactMap.put(FEATURIZER_MODEL_ENTRY_NAME, featurizerModel);
        this.checkArtifactMap();
    }

    public FeaturizerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return DefaultFeaturizerFactory.class;
    }

    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
    }

    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(FEATURIZER_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Featurizer model is incomplete!");
        }
    }

    public FeaturizerFactory getFactory() {
        return (FeaturizerFactory)this.toolFactory;
    }

    public AbstractModel getFeaturizerModel() {
        return (AbstractModel)this.artifactMap.get(FEATURIZER_MODEL_ENTRY_NAME);
    }

    public SequenceClassificationModel<TokenTag> getChunkerSequenceModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(FEATURIZER_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 10;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch(beamSize, (MaxentModel)this.artifactMap.get(FEATURIZER_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(FEATURIZER_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(FEATURIZER_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public FeatureDictionary getFeatureDictionary() {
        if (this.getFactory() != null) {
            return this.getFactory().getFeatureDictionary();
        }
        return null;
    }
}

