/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import opennlp.tools.util.eval.EvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.Featurizer;
import org.cogroo.tools.featurizer.FeaturizerEvaluationMonitor;

public class FeaturizerEvaluator
extends Evaluator<FeatureSample> {
    private Mean wordAccuracy = new Mean();
    private Featurizer featurizer;

    public FeaturizerEvaluator(Featurizer featurizer, FeaturizerEvaluationMonitor ... listeners) {
        super((EvaluationMonitor[])listeners);
        this.featurizer = featurizer;
    }

    protected FeatureSample processSample(FeatureSample reference) {
        String[] predictedFeatures = this.featurizer.featurize(reference.getSentence(), reference.getTags());
        String[] referenceTags = reference.getFeatures();
        for (int i = 0; i < referenceTags.length; ++i) {
            if (referenceTags[i].equals(predictedFeatures[i])) {
                this.wordAccuracy.add(1.0);
                continue;
            }
            this.wordAccuracy.add(0.0);
        }
        FeatureSample result = new FeatureSample(reference.getSentence(), reference.getLemmas(), reference.getTags(), predictedFeatures);
        return result;
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }
}

