/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import org.cogroo.tools.featurizer.FeatureSample;

public class FeatureSampleStream
extends FilterObjectStream<String, FeatureSample> {
    public FeatureSampleStream(ObjectStream<String> samples) {
        super(samples);
    }

    public FeatureSample read() throws IOException {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> lemmas = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        String line = (String)this.samples.read();
        while (line != null && !line.equals("")) {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                System.err.println("Skipping corrupt line: " + line);
            } else {
                toks.add(parts[0]);
                lemmas.add(parts[0]);
                tags.add(parts[1]);
                preds.add(parts[2]);
            }
            line = (String)this.samples.read();
        }
        if (toks.size() > 0) {
            return new FeatureSample(toks, lemmas, tags, preds);
        }
        return null;
    }
}

