/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import opennlp.tools.postag.ExtendedPOSDictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.UncloseableInputStream;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.tools.featurizer.FeaturizerFactory;

public class DefaultFeaturizerFactory
extends FeaturizerFactory {
    private static final String FEATURE_DICTIONARY_ENTRY_NAME = "tags.tagdict";

    public DefaultFeaturizerFactory() {
    }

    public DefaultFeaturizerFactory(FeatureDictionary featureDictionary, String cgFlags) {
        super(featureDictionary, cgFlags);
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        ExtendedTagDictionarySerializer.register(serializers);
        return serializers;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.featureDictionary != null) {
            artifactMap.put(FEATURE_DICTIONARY_ENTRY_NAME, this.featureDictionary);
        }
        return artifactMap;
    }

    @Override
    protected FeatureDictionary loadFeatureDictionary() {
        if (this.artifactProvider != null) {
            return (FeatureDictionary)this.artifactProvider.getArtifact(FEATURE_DICTIONARY_ENTRY_NAME);
        }
        return null;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        Object tagdictEntry = this.artifactProvider.getArtifact(FEATURE_DICTIONARY_ENTRY_NAME);
        if (tagdictEntry != null && !(tagdictEntry instanceof FeatureDictionary)) {
            throw new InvalidFormatException("Feature dictionary has wrong type!");
        }
    }

    static class ExtendedTagDictionarySerializer
    implements ArtifactSerializer<ExtendedPOSDictionary> {
        ExtendedTagDictionarySerializer() {
        }

        public ExtendedPOSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return ExtendedPOSDictionary.create((InputStream)new UncloseableInputStream(in));
        }

        public void serialize(ExtendedPOSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }

        static void register(Map<String, ArtifactSerializer> factories) {
            factories.put("tagdict", new ExtendedTagDictionarySerializer());
        }
    }

    static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        POSDictionarySerializer() {
        }

        public POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return POSDictionary.create((InputStream)new UncloseableInputStream(in));
        }

        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }

        static void register(Map<String, ArtifactSerializer> factories) {
            factories.put("tagdict", new POSDictionarySerializer());
        }
    }
}

