/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.formats.ad;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.formats.ad.ADFeaturizerSampleStream;
import org.cogroo.tools.featurizer.FeatureSample;

public class ADFeatureSampleStreamFactory
extends LanguageSampleStreamFactory<FeatureSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(FeatureSample.class, (String)"ad", (ObjectStreamFactory)new ADFeatureSampleStreamFactory(Parameters.class));
    }

    protected <P> ADFeatureSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<FeatureSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        this.language = params.getLang();
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory((File)params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)e);
        }
        ADFeaturizerSampleStream sentenceStream = new ADFeaturizerSampleStream((ObjectStream<String>)lineStream, params.getExpandME());
        return sentenceStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="start", description="index of first sentence")
        @ArgumentParser.OptionalParameter
        public Integer getStart();

        @ArgumentParser.ParameterDescription(valueName="end", description="index of last sentence")
        @ArgumentParser.OptionalParameter
        public Integer getEnd();

        @ArgumentParser.ParameterDescription(valueName="expandME", description="expand multiword expressions.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getExpandME();
    }
}

