/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.formats.ad;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.formats.ad.ADExpNameSampleStream;

public class ADExpNameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, (String)"adexp", (ObjectStreamFactory)new ADExpNameSampleStreamFactory(Parameters.class));
    }

    protected <P> ADExpNameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        this.language = params.getLang();
        String tags = params.getTags();
        HashSet<String> tagSet = null;
        if (tags != null) {
            tagSet = new HashSet<String>();
            tagSet.addAll(Arrays.asList(tags.split(",")));
        }
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory((File)params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)e);
        }
        return new ADExpNameSampleStream((ObjectStream<String>)lineStream, tagSet, true);
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="tags", description="comma separated outcome tags, if not specified all will be included")
        @ArgumentParser.OptionalParameter
        public String getTags();
    }
}

