/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.dictionary.impl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import opennlp.tools.postag.TagDictionary;
import org.apache.log4j.Logger;
import org.cogroo.dictionary.LemmaDictionary;
import org.cogroo.util.ByteArrayUtil;
import org.cogroo.util.CacheWrapper;
import org.cogroo.util.PairWordPOSTag;

public class FSADictionary
implements TagDictionary,
LemmaDictionary,
Iterable<String> {
    protected static final Logger LOGGER = Logger.getLogger(FSADictionary.class);
    private volatile DictionaryLookup dictLookup;
    private CacheWrapper<String[]> tagCache = new CacheWrapper<String[]>(){

        @Override
        public String[] compute(String key) {
            List data = null;
            String lowerKey = key.toLowerCase();
            try {
                data = FSADictionary.this.dictLookup.lookup((CharSequence)key);
            }
            catch (Throwable e) {
                LOGGER.error((Object)("Exception in dictionary lookup. Please report the bug. Word: [" + key + "]"), e);
                throw e;
            }
            if (data.size() > 0) {
                ArrayList<String> tags = new ArrayList<String>(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    if (!FSADictionary.this.isValid((WordData)data.get(i))) continue;
                    tags.add(((WordData)data.get(i)).getTag().toString());
                }
                if (tags.size() > 0) {
                    String[] res = tags.toArray(new String[tags.size()]);
                    return res;
                }
                return null;
            }
            if (!key.equals(lowerKey)) {
                return this.compute(lowerKey);
            }
            return null;
        }
    };
    private CacheWrapper<List<PairWordPOSTag>> lemmaTagCache = new CacheWrapper<List<PairWordPOSTag>>(){

        @Override
        public List<PairWordPOSTag> compute(String key) {
            String lowerKey = key.toLowerCase();
            List data = FSADictionary.this.dictLookup.lookup((CharSequence)key);
            if (data.size() > 0) {
                ArrayList<PairWordPOSTag> list = new ArrayList<PairWordPOSTag>(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    WordData wd = (WordData)data.get(i);
                    if (!FSADictionary.this.isValid(wd)) continue;
                    list.add(new PairWordPOSTag(wd.getStem().toString(), wd.getTag().toString()));
                }
                List<PairWordPOSTag> tags = Collections.unmodifiableList(list);
                return tags;
            }
            if (!key.equals(lowerKey)) {
                return this.compute(lowerKey);
            }
            return Collections.emptyList();
        }
    };

    private FSADictionary(DictionaryLookup dictLookup) {
        this.dictLookup = dictLookup;
    }

    private String[] tagLookup(String word) {
        return this.tagCache.get(word);
    }

    private List<PairWordPOSTag> lemmaTagLookup(String word) {
        return this.lemmaTagCache.get(word);
    }

    private boolean isValid(WordData wd) {
        if (wd.getStem() == null) {
            LOGGER.error((Object)("Got invalid entry from FSA dictionary: " + wd));
            return false;
        }
        return true;
    }

    public String[] getTags(String word) {
        if (word == null) {
            return null;
        }
        return this.tagLookup(word);
    }

    @Override
    public String[] getLemmas(String word, String tag) {
        ArrayList<String> output = new ArrayList<String>();
        List<PairWordPOSTag> pairs = this.lemmaTagLookup(word);
        for (PairWordPOSTag pairWordPOSTag : pairs) {
            boolean match = false;
            if (pairWordPOSTag.getPosTag().equals(tag)) {
                match = true;
            } else if ("n-adj".equals(pairWordPOSTag.getPosTag())) {
                if ("n".equals(tag) || "adj".equals(tag)) {
                    match = true;
                }
            } else if ("n-adj".equals(tag) && ("n".equals(pairWordPOSTag.getPosTag()) || "adj".equals(pairWordPOSTag.getPosTag()))) {
                match = true;
            }
            if (!match) continue;
            output.add(pairWordPOSTag.getWord());
        }
        return output.toArray(new String[output.size()]);
    }

    public List<PairWordPOSTag> getTagsAndLemms(String aWord) {
        return this.lemmaTagLookup(aWord);
    }

    public static TagDictionary create(String path) throws IllegalArgumentException, IOException {
        FileInputStream fsaData = new FileInputStream(path);
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName((String)path));
        return FSADictionary.create(fsaData, featuresData);
    }

    public static byte[] getFSADictionaryInfo(String path) throws IOException {
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName((String)path));
        return ByteArrayUtil.toByteArray(featuresData);
    }

    public static byte[] getFSADictionaryData(String path) throws IOException {
        FileInputStream featuresData = new FileInputStream(path);
        return ByteArrayUtil.toByteArray(featuresData);
    }

    public static FSADictionary create(InputStream fsaData, InputStream featuresData) throws IllegalArgumentException, IOException {
        DictionaryLookup dictLookup = new DictionaryLookup(Dictionary.readAndClose((InputStream)fsaData, (InputStream)featuresData));
        return new FSADictionary(dictLookup);
    }

    public static TagDictionary create(byte[] dictData, byte[] dictInfo) throws IllegalArgumentException, IOException {
        return FSADictionary.create(new ByteArrayInputStream(dictData), new ByteArrayInputStream(dictInfo));
    }

    public static FSADictionary createFromResources(String path) throws IllegalArgumentException, IOException {
        InputStream dic = FSADictionary.class.getResourceAsStream(path);
        InputStream info = FSADictionary.class.getResourceAsStream(Dictionary.getExpectedFeaturesName((String)path));
        FSADictionary fsa = FSADictionary.create(dic, info);
        dic.close();
        info.close();
        return fsa;
    }

    @Override
    public Iterator<String> iterator() {
        return new IteratorWrapper(this.dictLookup.iterator());
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        long start = System.nanoTime();
        String path = "/fsa_dictionaries/pos/pt_br_jspell_corpus";
        InputStream dict = FSADictionary.class.getResourceAsStream(path + ".dict");
        InputStream info = FSADictionary.class.getResourceAsStream(path + ".info");
        FSADictionary td = FSADictionary.create(dict, info);
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter a query: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            if (input.equals("0")) {
                input = "c\u00e3o";
            }
            List<PairWordPOSTag> pair = td.getTagsAndLemms(input);
            for (PairWordPOSTag pairWordPOSTag : pair) {
                System.out.println(pairWordPOSTag.getPosTag() + " : " + pairWordPOSTag.getWord());
            }
            System.out.print("Enter a query: ");
            input = kb.nextLine();
        }
    }

    private static class IteratorWrapper
    implements Iterator<String> {
        private final Iterator<WordData> innerIterator;

        public IteratorWrapper(Iterator<WordData> iterator) {
            this.innerIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public String next() {
            WordData wd = this.innerIterator.next();
            if (wd != null) {
                return wd.getWord().toString();
            }
            return null;
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }
    }
}

