/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.featurizer;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.cmdline.featurizer.FeaturizerModelLoader;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerME;
import org.cogroo.tools.featurizer.FeaturizerModel;

public class FeaturizerMETool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "learnable Featurizer";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            FeaturizerModel model = (FeaturizerModel)((Object)new FeaturizerModelLoader().load(new File(args[0])));
            FeaturizerME Featurizer2 = new FeaturizerME(model);
            PlainTextByLineStream lineStream = null;
            try {
                lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError((IOException)e);
            }
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            try {
                String line;
                while ((line = (String)lineStream.read()) != null) {
                    POSSample posSample;
                    try {
                        posSample = POSSample.parse((String)line);
                    }
                    catch (InvalidFormatException e) {
                        System.err.println("Invalid format:");
                        System.err.println(line);
                        continue;
                    }
                    String[] feats = Featurizer2.featurize(posSample.getSentence(), posSample.getTags());
                    String[] empty = new String[feats.length];
                    System.out.println(new FeatureSample(posSample.getSentence(), empty, posSample.getTags(), feats).toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError((IOException)e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

