/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.featurizer;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.util.ObjectStream;
import org.cogroo.cmdline.featurizer.FeaturizerEvaluationErrorListener;
import org.cogroo.cmdline.featurizer.FeaturizerModelLoader;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerEvaluationMonitor;
import org.cogroo.tools.featurizer.FeaturizerEvaluator;
import org.cogroo.tools.featurizer.FeaturizerME;
import org.cogroo.tools.featurizer.FeaturizerModel;

public final class FeaturizerEvaluatorTool
extends AbstractEvaluatorTool<FeatureSample, EvalToolParams> {
    public FeaturizerEvaluatorTool() {
        super(FeatureSample.class, EvalToolParams.class);
    }

    public String getShortDescription() {
        return "Measures the performance of the Chunker model with the reference data";
    }

    public void run(String format, String[] args) {
        super.run(format, args);
        FeaturizerModel model = (FeaturizerModel)((Object)new FeaturizerModelLoader().load(((EvalToolParams)this.params).getModel()));
        LinkedList<FeaturizerEvaluationErrorListener> listeners = new LinkedList<FeaturizerEvaluationErrorListener>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new FeaturizerEvaluationErrorListener());
        }
        FeaturizerEvaluator evaluator = new FeaturizerEvaluator(new FeaturizerME(model), listeners.toArray(new FeaturizerEvaluationMonitor[listeners.size()]));
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<FeatureSample> measuredSampleStream = new ObjectStream<FeatureSample>(){

            public FeatureSample read() throws IOException {
                monitor.incrementCounter();
                return (FeatureSample)FeaturizerEvaluatorTool.this.sampleStream.read();
            }

            public void reset() throws IOException {
                FeaturizerEvaluatorTool.this.sampleStream.reset();
            }

            public void close() throws IOException {
                FeaturizerEvaluatorTool.this.sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate((ObjectStream)measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage());
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException iOException) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        System.out.println(evaluator.getWordAccuracy());
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
    }
}

