/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionaryEntryPersistor;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.postag.ExtendedTagDictionary;
import opennlp.tools.postag.Triple;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;
import org.cogroo.tools.featurizer.WordTag;

public class ExtendedPOSDictionary
implements Iterable<WordTag>,
ExtendedTagDictionary {
    private Map<String, List<Triple>> dictionary = new HashMap<String, List<Triple>>();
    private static final String ATTR_TAGS = "tags";
    private static final String ATTR_LEMMAS = "lemmas";
    private static final String ATTR_FEATS = "feats";
    private boolean caseSensitive = true;

    public ExtendedPOSDictionary() {
        this(true);
    }

    public ExtendedPOSDictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String[] getTags(String word) {
        if (this.caseSensitive) {
            return ExtendedPOSDictionary.getTags(this.dictionary.get(word));
        }
        return ExtendedPOSDictionary.getTags(this.dictionary.get(word.toLowerCase()));
    }

    @Override
    public String[] getFeatureTag(String word) {
        if (this.caseSensitive) {
            return ExtendedPOSDictionary.getFeats(this.dictionary.get(word));
        }
        return ExtendedPOSDictionary.getFeats(this.dictionary.get(word.toLowerCase()));
    }

    @Override
    public String[] getCompleteTag(String word) {
        if (this.caseSensitive) {
            return this.getCompleteTag(this.dictionary.get(word));
        }
        return this.getCompleteTag(this.dictionary.get(word.toLowerCase()));
    }

    void addTriple(String word, Triple triple) {
        ExtendedPOSDictionary.addTriple(this.dictionary, word, triple);
    }

    static void addTriple(Map<String, List<Triple>> dic, String word, Triple triple) {
        if (!dic.containsKey(word)) {
            dic.put(word, new ArrayList());
        }
        dic.get(word).add(triple);
    }

    @Override
    public Iterator<WordTag> iterator() {
        return new IteratorWrapper();
    }

    private static String tagsToString(String[] tags) {
        StringBuilder tagString = new StringBuilder();
        for (String tag : tags) {
            tagString.append(tag);
            tagString.append(' ');
        }
        if (tagString.length() > 0) {
            tagString.setLength(tagString.length() - 1);
        }
        return tagString.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entries = new Iterator<Entry>(){
            Iterator<String> iterator;
            {
                this.iterator = ExtendedPOSDictionary.this.dictionary.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Entry next() {
                String word = this.iterator.next();
                List triples = (List)ExtendedPOSDictionary.this.dictionary.get(word);
                Attributes tagAttribute = new Attributes();
                String[] tags = new String[triples.size()];
                String[] lemmas = new String[triples.size()];
                String[] feats = new String[triples.size()];
                int i = 0;
                for (Triple t : triples) {
                    tags[i] = t.getClazz();
                    lemmas[i] = t.getLemma();
                    feats[i++] = t.getFeats();
                }
                tagAttribute.setValue(ExtendedPOSDictionary.ATTR_TAGS, ExtendedPOSDictionary.tagsToString(tags));
                tagAttribute.setValue(ExtendedPOSDictionary.ATTR_LEMMAS, ExtendedPOSDictionary.tagsToString(lemmas));
                tagAttribute.setValue(ExtendedPOSDictionary.ATTR_FEATS, ExtendedPOSDictionary.tagsToString(feats));
                return new Entry(new StringList(word), tagAttribute);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionaryEntryPersistor.serialize((OutputStream)out, (Iterator)entries, (boolean)this.caseSensitive);
    }

    public String toString() {
        StringBuilder dictionaryString = new StringBuilder();
        int i = 0;
        for (String word : this.dictionary.keySet()) {
            dictionaryString.append(word).append(" -> ").append(ExtendedPOSDictionary.tagsToString(this.getTags(word)));
            dictionaryString.append("\n");
            if (i > 3) break;
            ++i;
        }
        if (dictionaryString.length() > 0) {
            dictionaryString.setLength(dictionaryString.length() - 1);
        }
        return dictionaryString.toString();
    }

    public static ExtendedPOSDictionary create(InputStream in) throws IOException, InvalidFormatException {
        boolean isCaseSensitive;
        ExtendedPOSDictionary newPosDict = new ExtendedPOSDictionary();
        newPosDict.caseSensitive = isCaseSensitive = DictionaryEntryPersistor.create((InputStream)in, entry -> {
            String tagString = entry.getAttributes().getValue(ATTR_TAGS);
            String lemmaString = entry.getAttributes().getValue(ATTR_LEMMAS);
            String featString = entry.getAttributes().getValue(ATTR_FEATS);
            String[] tags = tagString.split(" ");
            String[] lemmas = lemmaString.split(" ");
            String[] feats = featString.split(" ");
            StringList word = entry.getTokens();
            if (word.size() != 1) {
                throw new InvalidFormatException("Each entry must have exactly one token! " + word);
            }
            if (tags.length != lemmas.length || tags.length != feats.length) {
                throw new InvalidFormatException("Each entry must have exactly number of tags, lemmas and feats! " + word);
            }
            ExtendedPOSDictionary.addTriple(newPosDict.dictionary, word.getToken(0), ExtendedPOSDictionary.createTriple(tags, lemmas, feats));
        });
        if (!isCaseSensitive) {
            HashMap<String, List<Triple>> lowerCasedDictionary = new HashMap<String, List<Triple>>();
            for (Map.Entry<String, List<Triple>> entry2 : newPosDict.dictionary.entrySet()) {
                lowerCasedDictionary.put(StringUtil.toLowerCase((CharSequence)entry2.getKey()), entry2.getValue());
            }
            newPosDict.dictionary = lowerCasedDictionary;
        }
        return newPosDict;
    }

    protected static void addTriple(Map<String, List<Triple>> dict, String token, Triple[] triple) {
        for (Triple t : triple) {
            ExtendedPOSDictionary.addTriple(dict, token, t);
        }
    }

    @Override
    public String[] getFeatures(String word, String tag) {
        ArrayList<String> feats = new ArrayList<String>();
        if (this.caseSensitive) {
            List<Triple> triples = this.dictionary.get(word);
            if (triples == null) {
                return null;
            }
            for (Triple t : triples) {
                if (!tag.equals(t.getClazz())) continue;
                feats.add(t.getFeats());
            }
        } else {
            List<Triple> triples = this.dictionary.get(word.toLowerCase());
            if (triples == null) {
                return null;
            }
            for (Triple t : triples) {
                if (!tag.equals(t.getClazz())) continue;
                feats.add(t.getFeats());
            }
        }
        if (feats.size() > 0) {
            return feats.toArray(new String[feats.size()]);
        }
        return null;
    }

    @Override
    public String getLemma(String word, String tag) {
        if (this.caseSensitive) {
            List<Triple> triples = this.dictionary.get(word);
            if (triples == null) {
                return null;
            }
            for (Triple t : triples) {
                if (!tag.equals(t.getClazz())) continue;
                return t.getLemma();
            }
        } else {
            List<Triple> triples = this.dictionary.get(word.toLowerCase());
            if (triples == null) {
                return null;
            }
            for (Triple t : triples) {
                if (!tag.equals(t.getClazz())) continue;
                return t.getLemma();
            }
        }
        return null;
    }

    private static String[] getFeats(List<Triple> triples) {
        if (triples == null) {
            return null;
        }
        String[] feats = new String[triples.size()];
        int i = 0;
        for (Triple t : triples) {
            feats[i++] = t.getFeats();
        }
        return feats;
    }

    private String[] getCompleteTag(List<Triple> triples) {
        if (triples == null) {
            return null;
        }
        String[] feats = new String[triples.size()];
        int i = 0;
        for (Triple t : triples) {
            feats[i++] = t.getClazz() + "_" + t.getFeats();
        }
        return feats;
    }

    private static String[] getTags(List<Triple> triples) {
        if (triples == null) {
            return null;
        }
        String[] tags = new String[triples.size()];
        int i = 0;
        for (Triple t : triples) {
            tags[i++] = t.getClazz();
        }
        return tags;
    }

    protected static Triple[] createTriple(String[] tags, String[] lemmas, String[] feats) {
        Triple[] triples = new Triple[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            triples[i] = new Triple(tags[i], lemmas[i], feats[i]);
        }
        return triples;
    }

    private class IteratorWrapper
    implements Iterator<WordTag> {
        Iterator<String> inner;
        String word;
        Iterator<Triple> innerTriple;

        private IteratorWrapper() {
            this.inner = ExtendedPOSDictionary.this.dictionary.keySet().iterator();
            this.word = null;
            this.innerTriple = null;
        }

        @Override
        public boolean hasNext() {
            if (this.innerTriple != null && this.innerTriple.hasNext()) {
                return true;
            }
            return this.inner.hasNext();
        }

        @Override
        public WordTag next() {
            if (this.innerTriple == null || !this.innerTriple.hasNext()) {
                this.word = this.inner.next();
                this.innerTriple = ((List)ExtendedPOSDictionary.this.dictionary.get(this.word)).iterator();
            }
            Triple val = this.innerTriple.next();
            return new WordTag(this.word, val.getClazz());
        }

        @Override
        public void remove() {
        }
    }
}

