/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.formats.ad.ADSentenceSampleStream;
import opennlp.tools.formats.ad.ADTokenSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public class SentenceTest {
    public static void main(String[] a) throws Exception {
        ADTokenSampleStreamFactory factory = new ADTokenSampleStreamFactory(ADTokenSampleStreamFactory.Parameters.class);
        File dict = new File("/Users/wcolen/Documents/wrks/opennlp/opennlp/opennlp-tools/lang/pt/tokenizer/pt-detokenizer.xml");
        File data = new File("/Users/wcolen/Documents/wrks/corpus/Bosque/Bosque_CF_8.0.ad.txt");
        String[] args = new String[]{"-data", data.getCanonicalPath(), "-encoding", "ISO-8859-1", "-lang", "pt", "-detokenizer", dict.getCanonicalPath()};
        ObjectStream tokenSampleStream = factory.create(args);
        TokenSample sample = (TokenSample)tokenSampleStream.read();
        BufferedWriter fromNameSample = new BufferedWriter(new FileWriter("fromNameSample.txt"));
        while (sample != null) {
            fromNameSample.append(sample.getText().toLowerCase() + "\n");
            sample = (TokenSample)tokenSampleStream.read();
        }
        fromNameSample.close();
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory((File)data);
        ADSentenceSampleStream sampleStream = new ADSentenceSampleStream((ObjectStream)new PlainTextByLineStream(sampleDataIn, "ISO-8859-1"), true);
        SentenceSample sentSample = (SentenceSample)sampleStream.read();
        BufferedWriter fromSentence = new BufferedWriter(new FileWriter("fromSentence.txt"));
        while (sentSample != null) {
            String[] sentences;
            for (String string : sentences = Span.spansToStrings((Span[])sentSample.getSentences(), (CharSequence)sentSample.getDocument())) {
                fromSentence.append(string.toLowerCase() + "\n");
            }
            sentSample = (SentenceSample)sampleStream.read();
        }
        fromSentence.close();
    }
}

