/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.stax;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AbstractMessageReader;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.stax.AttributeReader;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;

public class ElementReader
extends AbstractMessageReader
implements MessageReader {
    private static final Pattern QNAME_PATTERN = Pattern.compile("([^:]+):([^:]+)");
    private DepthXMLStreamReader root;
    private String value;
    private String localName;
    private QName name;
    private QName xsiType;
    private boolean hasCheckedChildren = false;
    private boolean hasChildren = false;
    private String namespace;
    private int depth;
    private int currentAttribute = 0;

    public ElementReader(DepthXMLStreamReader root) {
        this.root = root;
        this.localName = root.getLocalName();
        this.name = root.getName();
        this.namespace = root.getNamespaceURI();
        this.extractXsiType();
        this.depth = root.getDepth();
    }

    public ElementReader(XMLStreamReader reader) {
        this(new DepthXMLStreamReader(reader));
    }

    public ElementReader(InputStream is) throws XMLStreamException {
        XMLStreamReader xmlReader = STAXUtils.createXMLStreamReader((InputStream)is, null, null);
        xmlReader.nextTag();
        this.root = new DepthXMLStreamReader(xmlReader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.namespace = this.root.getNamespaceURI();
        this.extractXsiType();
        this.depth = this.root.getDepth();
    }

    private void extractXsiType() {
        String xsiTypeQname = this.root.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiTypeQname != null) {
            Matcher m = QNAME_PATTERN.matcher(xsiTypeQname);
            if (m.matches()) {
                NamespaceContext nc = this.root.getNamespaceContext();
                this.xsiType = new QName(nc.getNamespaceURI(m.group(1)), m.group(2), m.group(1));
            } else {
                this.xsiType = new QName(this.namespace, xsiTypeQname, "");
            }
        }
    }

    public String getValue() {
        if (this.value == null) {
            try {
                this.value = this.root.getElementText();
                while (this.checkHasMoreChildReaders()) {
                }
            }
            catch (XMLStreamException e) {
                throw new XFireRuntimeException("Could not read XML stream.", (Throwable)e);
            }
            if (this.value == null) {
                this.value = "";
            }
        }
        return this.value.trim();
    }

    public String getValue(String ns, String attr) {
        return this.root.getAttributeValue(ns, attr);
    }

    public boolean hasMoreElementReaders() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        return this.hasChildren;
    }

    private boolean checkHasMoreChildReaders() {
        try {
            int event = this.root.getEventType();
            while (this.root.hasNext()) {
                switch (event) {
                    case 1: {
                        if (this.root.getDepth() <= this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = true;
                        return true;
                    }
                    case 2: {
                        if (this.root.getDepth() > this.depth + 1) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        if (this.root.hasNext()) {
                            this.root.next();
                        }
                        return false;
                    }
                    case 8: {
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        return false;
                    }
                }
                if (!this.root.hasNext()) continue;
                event = this.root.next();
            }
            this.hasCheckedChildren = true;
            this.hasChildren = false;
            return false;
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error parsing document.", (Throwable)e);
        }
    }

    public MessageReader getNextElementReader() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        if (!this.hasChildren) {
            return null;
        }
        this.hasCheckedChildren = false;
        return new ElementReader(this.root);
    }

    public QName getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getXsiType() {
        return this.xsiType;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.root;
    }

    public boolean hasMoreAttributeReaders() {
        if (!this.root.isStartElement()) {
            return false;
        }
        return this.currentAttribute < this.root.getAttributeCount();
    }

    public MessageReader getAttributeReader(QName qName) {
        return new AttributeReader(qName, this.root.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()));
    }

    public MessageReader getNextAttributeReader() {
        AttributeReader reader = new AttributeReader(this.root.getAttributeName(this.currentAttribute), this.root.getAttributeValue(this.currentAttribute));
        ++this.currentAttribute;
        return reader;
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.root.getNamespaceURI(prefix);
    }
}

