/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.UpdateCenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateCenterSerializer {
    private UpdateCenterSerializer() {
    }

    private static void set(Properties props, String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            props.setProperty(key, value);
        }
    }

    private static void set(Properties props, String key, Collection values) {
        if (values != null && !values.isEmpty()) {
            props.setProperty(key, StringUtils.join((Collection)values, (String)","));
        }
    }

    private static void set(Properties props, Plugin plugin, String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            props.setProperty(plugin.getKey() + "." + key, value);
        }
    }

    private static void set(Properties props, Plugin plugin, String key, Collection values) {
        if (values != null && !values.isEmpty()) {
            props.setProperty(plugin.getKey() + "." + key, StringUtils.join((Collection)values, (String)","));
        }
    }

    public static Properties toProperties(UpdateCenter center) {
        Properties p = new Properties();
        UpdateCenterSerializer.set(p, "date", FormatUtils.toString(center.getDate(), true));
        UpdateCenterSerializer.set(p, "sonar.versions", center.getSonar().getVersions());
        String sonarPrefix = "sonar.";
        for (Release sonarRelease : center.getSonar().getReleases()) {
            UpdateCenterSerializer.set(p, sonarPrefix + sonarRelease.getVersion() + ".downloadUrl", sonarRelease.getDownloadUrl());
            UpdateCenterSerializer.set(p, sonarPrefix + sonarRelease.getVersion() + ".changelogUrl", sonarRelease.getChangelogUrl());
            UpdateCenterSerializer.set(p, sonarPrefix + sonarRelease.getVersion() + ".description", sonarRelease.getDescription());
            UpdateCenterSerializer.set(p, sonarPrefix + sonarRelease.getVersion() + ".date", FormatUtils.toString(sonarRelease.getDate(), false));
        }
        ArrayList pluginKeys = Lists.newArrayList();
        for (Plugin plugin : center.getUpdateCenterPluginReferential().getPlugins()) {
            UpdateCenterSerializer.addPlugin(plugin, pluginKeys, p);
        }
        UpdateCenterSerializer.set(p, "plugins", pluginKeys);
        return p;
    }

    private static void addPlugin(Plugin plugin, List<String> pluginKeys, Properties p) {
        pluginKeys.add(plugin.getKey());
        UpdateCenterSerializer.set(p, plugin, "name", plugin.getName());
        UpdateCenterSerializer.set(p, plugin, "description", plugin.getDescription());
        UpdateCenterSerializer.set(p, plugin, "category", plugin.getCategory());
        UpdateCenterSerializer.set(p, plugin, "homepageUrl", plugin.getHomepageUrl());
        UpdateCenterSerializer.set(p, plugin, "license", plugin.getLicense());
        UpdateCenterSerializer.set(p, plugin, "organization", plugin.getOrganization());
        UpdateCenterSerializer.set(p, plugin, "organizationUrl", plugin.getOrganizationUrl());
        UpdateCenterSerializer.set(p, plugin, "termsConditionsUrl", plugin.getTermsConditionsUrl());
        UpdateCenterSerializer.set(p, plugin, "issueTrackerUrl", plugin.getIssueTrackerUrl());
        UpdateCenterSerializer.set(p, plugin, "scm", plugin.getSourcesUrl());
        UpdateCenterSerializer.set(p, plugin, "developers", StringUtils.join(plugin.getDevelopers(), (String)","));
        ArrayList<String> releaseKeys = new ArrayList<String>();
        for (Release release : plugin.getReleases()) {
            releaseKeys.add(release.getVersion().toString());
            if (release.getParent() != null) {
                UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".parent", release.getParent().getKey());
            }
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".requiredSonarVersions", StringUtils.join(release.getRequiredSonarVersions(), (String)","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".downloadUrl", release.getDownloadUrl());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".changelogUrl", release.getChangelogUrl());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".description", release.getDescription());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".date", FormatUtils.toString(release.getDate(), false));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".requirePlugins", StringUtils.join((Object[])UpdateCenterSerializer.getRequiredList(release), (String)","));
        }
        UpdateCenterSerializer.set(p, plugin, "versions", releaseKeys);
    }

    public static void toProperties(UpdateCenter sonar, File toFile) {
        FileOutputStream output = null;
        try {
            output = FileUtils.openOutputStream((File)toFile);
            UpdateCenterSerializer.toProperties(sonar).store(output, "Generated file");
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to store update center properties to: " + toFile.getAbsolutePath(), e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    private static String[] getRequiredList(Release release) {
        ArrayList requiredStringList = Lists.newArrayList();
        for (Release requiredRelease : release.getOutgoingDependencies()) {
            requiredStringList.add(requiredRelease.getArtifact().getKey() + ":" + requiredRelease.getVersion().getName());
        }
        return requiredStringList.toArray(new String[0]);
    }
}

