/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.ArrayList;
import java.util.List;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SonarUpdate
implements Comparable<SonarUpdate> {
    private Release release;
    private List<Plugin> compatiblePlugins = new ArrayList<Plugin>();
    private List<Plugin> incompatiblePlugins = new ArrayList<Plugin>();
    private List<Release> pluginsToUpgrade = new ArrayList<Release>();

    public SonarUpdate(Release release) {
        this.release = release;
    }

    public Release getRelease() {
        return this.release;
    }

    public List<Plugin> getCompatiblePlugins() {
        return this.compatiblePlugins;
    }

    public List<Plugin> getIncompatiblePlugins() {
        return this.incompatiblePlugins;
    }

    public List<Release> getPluginsToUpgrade() {
        return this.pluginsToUpgrade;
    }

    public boolean hasWarnings() {
        return this.isIncompatible() || this.requiresPluginUpgrades();
    }

    public boolean requiresPluginUpgrades() {
        return !this.pluginsToUpgrade.isEmpty();
    }

    public boolean isIncompatible() {
        return !this.incompatiblePlugins.isEmpty();
    }

    public void addCompatiblePlugin(Plugin plugin) {
        this.compatiblePlugins.add(plugin);
    }

    public void addIncompatiblePlugin(Plugin plugin) {
        this.incompatiblePlugins.add(plugin);
    }

    public void addPluginToUpgrade(Release plugin) {
        this.pluginsToUpgrade.add(plugin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SonarUpdate update = (SonarUpdate)o;
        return this.release.equals(update.release);
    }

    public int hashCode() {
        return this.release.hashCode();
    }

    @Override
    public int compareTo(SonarUpdate su) {
        return this.release.compareTo(su.release);
    }
}

