/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskExtension;

public class TaskDefinition
implements TaskExtension,
Comparable<TaskDefinition> {
    static final String KEY_PATTERN = "[a-zA-Z0-9\\-\\_]+";
    private final String key;
    private final String description;
    private final Class<? extends Task> taskClass;

    private TaskDefinition(Builder builder) {
        this.key = builder.key;
        this.description = builder.description;
        this.taskClass = builder.taskClass;
    }

    public String description() {
        return this.description;
    }

    public String key() {
        return this.key;
    }

    public Class<? extends Task> taskClass() {
        return this.taskClass;
    }

    public String toString() {
        return "Task " + this.key + "[class=" + this.taskClass.getName() + ", desc=" + this.description + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(TaskDefinition o) {
        return this.key.compareTo(o.key);
    }

    public static class Builder {
        private String key;
        private String description;
        private Class<? extends Task> taskClass;

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder description(String s) {
            this.description = s;
            return this;
        }

        public Builder taskClass(Class<? extends Task> taskClass) {
            this.taskClass = taskClass;
            return this;
        }

        public TaskDefinition build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Task key must be set");
            Preconditions.checkArgument((boolean)Pattern.matches(TaskDefinition.KEY_PATTERN, this.key), (Object)("Task key '" + this.key + "' must match " + TaskDefinition.KEY_PATTERN));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.description) ? 1 : 0) != 0, (Object)("Description must be set for task '" + this.key + "'"));
            Preconditions.checkArgument((this.taskClass != null ? 1 : 0) != 0, (Object)("Class must be set for task '" + this.key + "'"));
            return new TaskDefinition(this);
        }
    }
}

