/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.IssueFilter;

public class NoSonarFilter
implements IssueFilter {
    private final Map<String, Set<Integer>> noSonarLinesByResource = Maps.newHashMap();

    public NoSonarFilter addComponent(String componentKey, Set<Integer> noSonarLines) {
        this.noSonarLinesByResource.put(componentKey, noSonarLines);
        return this;
    }

    @Override
    public boolean accept(Issue issue) {
        boolean accepted = true;
        if (issue.line() != null) {
            Set<Integer> noSonarLines = this.noSonarLinesByResource.get(issue.componentKey());
            boolean bl = accepted = noSonarLines == null || !noSonarLines.contains(issue.line());
            if (!accepted && StringUtils.containsIgnoreCase((String)issue.ruleKey().rule(), (String)"nosonar")) {
                accepted = true;
            }
        }
        return accepted;
    }
}

