/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.workflow.condition;

import com.google.common.annotations.Beta;
import org.sonar.api.workflow.condition.AdminRoleCondition;
import org.sonar.api.workflow.condition.Condition;
import org.sonar.api.workflow.condition.HasProjectPropertyCondition;
import org.sonar.api.workflow.condition.HasReviewPropertyCondition;
import org.sonar.api.workflow.condition.NotCondition;
import org.sonar.api.workflow.condition.ResolutionCondition;
import org.sonar.api.workflow.condition.StatusCondition;

@Beta
public final class Conditions {
    private Conditions() {
    }

    public static Condition not(Condition c) {
        return new NotCondition(c);
    }

    public static Condition hasReviewProperty(String propertyKey) {
        return new HasReviewPropertyCondition(propertyKey);
    }

    public static Condition hasProjectProperty(String propertyKey) {
        return new HasProjectPropertyCondition(propertyKey);
    }

    public static Condition hasAdminRole() {
        return new AdminRoleCondition();
    }

    public static Condition statuses(String ... statuses) {
        return new StatusCondition(statuses);
    }

    public static Condition resolutions(String ... resolutions) {
        return new ResolutionCondition(resolutions);
    }
}

