/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.BatchSize;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="projects")
public class ResourceModel
extends BaseIdentifiable
implements Cloneable {
    public static final String SCOPE_PROJECT = "PRJ";
    public static final String QUALIFIER_PROJECT_TRUNK = "TRK";
    public static final int DESCRIPTION_COLUMN_SIZE = 2000;
    public static final int NAME_COLUMN_SIZE = 256;
    public static final int KEY_SIZE = 400;
    @Column(name="name", updatable=true, nullable=true, length=256)
    private String name;
    @Column(name="long_name", updatable=true, nullable=true, length=256)
    private String longName;
    @Column(name="description", updatable=true, nullable=true, length=2000)
    private String description;
    @Column(name="enabled", updatable=true, nullable=false)
    private Boolean enabled = Boolean.TRUE;
    @Column(name="scope", updatable=true, nullable=false, length=3)
    private String scope;
    @Column(name="qualifier", updatable=true, nullable=false, length=10)
    private String qualifier;
    @Column(name="kee", updatable=false, nullable=false, length=400)
    private String key;
    @Column(name="language", updatable=true, nullable=true, length=20)
    private String languageKey;
    @Column(name="root_id", updatable=true, nullable=true)
    private Integer rootId;
    @Column(name="copy_resource_id", updatable=true, nullable=true)
    private Integer copyResourceId;
    @Column(name="person_id", updatable=true, nullable=true)
    private Integer personId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=true, nullable=true)
    private Date createdAt;
    @OneToMany(mappedBy="resource", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=8)
    private List<ProjectLink> projectLinks = new ArrayList<ProjectLink>();

    public ResourceModel() {
        this.createdAt = new Date();
    }

    public ResourceModel(String scope, String key, String qualifier, Integer rootId, String name) {
        this();
        this.scope = scope;
        this.key = key;
        this.rootId = rootId;
        this.name = name;
        this.qualifier = qualifier;
    }

    public List<ProjectLink> getProjectLinks() {
        return this.projectLinks;
    }

    public void setProjectLinks(List<ProjectLink> projectLinks) {
        this.projectLinks = projectLinks;
    }

    public ProjectLink getProjectLink(String key) {
        for (ProjectLink projectLink : this.projectLinks) {
            if (!key.equals(projectLink.getKey())) continue;
            return projectLink;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.abbreviate((String)description, (int)2000);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.abbreviate((String)name, (int)256);
        if (this.longName == null) {
            this.longName = this.name;
        }
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String s) {
        this.longName = StringUtils.isBlank((String)s) ? this.name : StringUtils.abbreviate((String)s, (int)256);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getKey() {
        return this.key;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public void setLanguageKey(String lang) {
        this.languageKey = lang;
    }

    public Integer getCopyResourceId() {
        return this.copyResourceId;
    }

    public void setCopyResourceId(Integer i) {
        this.copyResourceId = i;
    }

    public Integer getPersonId() {
        return this.personId;
    }

    public ResourceModel setPersonId(Integer i) {
        this.personId = i;
        return this;
    }

    public void setKey(String key) {
        if (key.length() > 400) {
            throw new IllegalArgumentException("Resource key is too long, max is 400 characters. Got : " + key);
        }
        this.key = key;
    }

    public Integer getRootId() {
        return this.rootId;
    }

    public void setRootId(Integer rootId) {
        this.rootId = rootId;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceModel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ResourceModel other = (ResourceModel)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.enabled, (Object)other.enabled).append((Object)this.rootId, (Object)other.rootId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.key).append((Object)this.enabled).append((Object)this.rootId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("key", (Object)this.key).append("scope", (Object)this.scope).append("qualifier", (Object)this.qualifier).append("name", (Object)this.name).append("longName", (Object)this.longName).append("lang", (Object)this.languageKey).append("enabled", (Object)this.enabled).append("rootId", (Object)this.rootId).append("copyResourceId", (Object)this.copyResourceId).append("personId", (Object)this.personId).append("createdAt", (Object)this.createdAt).toString();
    }

    public Object clone() {
        ResourceModel clone = new ResourceModel(this.getScope(), this.getKey(), this.getQualifier(), this.getRootId(), this.getName());
        clone.setDescription(this.getDescription());
        clone.setEnabled(this.getEnabled());
        clone.setProjectLinks(this.getProjectLinks());
        clone.setLanguageKey(this.getLanguageKey());
        clone.setCopyResourceId(this.getCopyResourceId());
        clone.setLongName(this.getLongName());
        clone.setPersonId(this.getPersonId());
        clone.setCreatedAt(this.getCreatedAt());
        return clone;
    }

    public static ResourceModel build(Resource resource) {
        ResourceModel model = new ResourceModel();
        model.setEnabled(Boolean.TRUE);
        model.setDescription(resource.getDescription());
        model.setKey(resource.getKey());
        if (resource.getLanguage() != null) {
            model.setLanguageKey(resource.getLanguage().getKey());
        }
        if (StringUtils.isNotBlank((String)resource.getName())) {
            model.setName(resource.getName());
        } else {
            model.setName(resource.getKey());
        }
        model.setLongName(resource.getLongName());
        model.setQualifier(resource.getQualifier());
        model.setScope(resource.getScope());
        return model;
    }
}

