/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.IocContainer;
import org.sonar.api.utils.dag.DirectAcyclicGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchExtensionDictionnary {
    private MutablePicoContainer picoContainer;

    public BatchExtensionDictionnary(IocContainer iocContainer) {
        this.picoContainer = iocContainer.getPicoContainer();
    }

    public BatchExtensionDictionnary(MutablePicoContainer picoContainer) {
        this.picoContainer = picoContainer;
    }

    public <T> Collection<T> select(Class<T> type) {
        return this.select(type, null, false);
    }

    public <T> Collection<T> select(Class<T> type, Project project, boolean sort) {
        List<T> result = this.getFilteredExtensions(type, project);
        if (sort) {
            return this.sort(result);
        }
        return result;
    }

    public Collection<MavenPluginHandler> selectMavenPluginHandlers(Project project) {
        Collection<DependsUponMavenPlugin> selectedExtensions = this.select(DependsUponMavenPlugin.class, project, true);
        ArrayList handlers = Lists.newArrayList();
        for (DependsUponMavenPlugin extension : selectedExtensions) {
            MavenPluginHandler handler = extension.getMavenPluginHandler(project);
            if (handler == null) continue;
            boolean ok = true;
            if (handler instanceof CheckProject) {
                ok = ((CheckProject)((Object)handler)).shouldExecuteOnProject(project);
            }
            if (!ok) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    private List<BatchExtension> getExtensions() {
        ArrayList extensions = Lists.newArrayList();
        this.completeBatchExtensions((PicoContainer)this.picoContainer, extensions);
        return extensions;
    }

    private void completeBatchExtensions(PicoContainer picoContainer, List<BatchExtension> extensions) {
        if (picoContainer != null) {
            extensions.addAll(picoContainer.getComponents(BatchExtension.class));
            this.completeBatchExtensions(picoContainer.getParent(), extensions);
        }
    }

    private <T> List<T> getFilteredExtensions(Class<T> type, Project project) {
        ArrayList result = Lists.newArrayList();
        for (BatchExtension extension : this.getExtensions()) {
            if (!this.shouldKeep(type, extension, project)) continue;
            result.add(extension);
        }
        return result;
    }

    private boolean shouldKeep(Class type, Object extension, Project project) {
        boolean keep = ClassUtils.isAssignable(extension.getClass(), (Class)type);
        if (keep && project != null && ClassUtils.isAssignable(extension.getClass(), CheckProject.class)) {
            keep = ((CheckProject)extension).shouldExecuteOnProject(project);
        }
        return keep;
    }

    public <T> Collection<T> sort(Collection<T> extensions) {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (T extension : extensions) {
            dag.add(extension, new Object[0]);
            for (Object dependency : this.getDependencies(extension)) {
                dag.add(extension, dependency);
            }
            for (Object generates : this.getDependents(extension)) {
                dag.add(generates, extension);
            }
            this.completePhaseDependencies(dag, extension);
        }
        List sortedList = dag.sort();
        return Collections2.filter((Collection)sortedList, (Predicate)Predicates.in(extensions));
    }

    private <T> List getDependencies(T extension) {
        return this.evaluateAnnotatedClasses(extension, DependsUpon.class);
    }

    public <T> List getDependents(T extension) {
        return this.evaluateAnnotatedClasses(extension, DependedUpon.class);
    }

    private void completePhaseDependencies(DirectAcyclicGraph dag, Object extension) {
        Phase.Name phase = this.evaluatePhase(extension);
        dag.add(extension, new Object[]{phase});
        for (Phase.Name name : Phase.Name.values()) {
            if (phase.compareTo(name) < 0) {
                dag.add((Object)name, extension);
                continue;
            }
            if (phase.compareTo(name) <= 0) continue;
            dag.add(extension, new Object[]{name});
        }
    }

    protected List evaluateAnnotatedClasses(Object extension, Class annotation) {
        ArrayList results = Lists.newArrayList();
        for (Class<?> aClass = extension.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            this.evaluateClass(aClass, annotation, results);
            for (Method method : aClass.getDeclaredMethods()) {
                if (method.getAnnotation(annotation) == null) continue;
                this.checkAnnotatedMethod(method);
                this.evaluateMethod(extension, method, results);
            }
        }
        return results;
    }

    private void evaluateClass(Class extensionClass, Class annotationClass, List results) {
        Class<?>[] interfaces;
        Object annotation = extensionClass.getAnnotation(annotationClass);
        if (annotation != null) {
            if (annotation.annotationType().isAssignableFrom(DependsUpon.class)) {
                results.addAll(Arrays.asList(((DependsUpon)annotation).value()));
                results.addAll(Arrays.asList(((DependsUpon)annotation).classes()));
            } else if (annotation.annotationType().isAssignableFrom(DependedUpon.class)) {
                results.addAll(Arrays.asList(((DependedUpon)annotation).value()));
                results.addAll(Arrays.asList(((DependedUpon)annotation).classes()));
            }
        }
        for (Class<?> anInterface : interfaces = extensionClass.getInterfaces()) {
            this.evaluateClass(anInterface, annotationClass, results);
        }
    }

    protected Phase.Name evaluatePhase(Object extension) {
        Phase phaseAnnotation = AnnotationUtils.getClassAnnotation(extension, Phase.class);
        if (phaseAnnotation != null) {
            return phaseAnnotation.name();
        }
        return Phase.Name.DEFAULT;
    }

    private void evaluateMethod(Object extension, Method method, List results) {
        try {
            Object result = method.invoke(extension, new Object[0]);
            if (result != null) {
                if (result instanceof Class) {
                    results.addAll(this.picoContainer.getComponents((Class)result));
                } else if (result instanceof Collection) {
                    results.addAll((Collection)result);
                } else {
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not invoke method " + method, e);
        }
    }

    private void checkAnnotatedMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("Annotated method must be public :" + method);
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Annotated method must not have parameters :" + method);
        }
    }
}

