/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.resources.Language;

public class Languages
implements BatchComponent,
ServerComponent {
    private final Map<String, Language> map = new HashMap<String, Language>();

    public Languages(Language ... languages) {
        if (languages != null) {
            for (Language language : languages) {
                this.map.put(language.getKey(), language);
            }
        }
    }

    public String[] getSuffixes(String ... keys) {
        ArrayList<String> suffixes = new ArrayList<String>();
        for (Map.Entry<String, Language> entry : this.map.entrySet()) {
            if (!ArrayUtils.isEmpty((Object[])keys) && !ArrayUtils.contains((Object[])keys, (Object)entry.getKey())) continue;
            suffixes.addAll(Arrays.asList(entry.getValue().getFileSuffixes()));
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    public Language get(String key) {
        return this.map.get(key);
    }

    public void add(Language language) {
        this.map.put(language.getKey(), language);
    }
}

