/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClasspath
implements BatchComponent {
    protected MavenProject pom;
    private List<File> elements;
    private URLClassLoader classloader;

    public ProjectClasspath(MavenProject pom) {
        this.pom = pom;
    }

    public URLClassLoader getClassloader() {
        if (this.classloader == null) {
            this.classloader = this.createClassLoader();
        }
        return this.classloader;
    }

    public List<File> getElements() {
        if (this.elements == null) {
            this.elements = this.createElements();
        }
        return this.elements;
    }

    protected URLClassLoader createClassLoader() {
        try {
            ArrayList urls = Lists.newArrayList();
            for (File file : this.getElements()) {
                urls.add(file.toURI().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        }
        catch (MalformedURLException e) {
            throw new SonarException("Fail to create the project classloader. Classpath element is unvalid.", e);
        }
    }

    protected List<File> createElements() {
        try {
            File outputDirectoryFile;
            ArrayList files = Lists.newArrayList();
            if (this.pom.getCompileClasspathElements() != null) {
                for (String classPathString : this.pom.getCompileClasspathElements()) {
                    files.add(new File(classPathString));
                }
            }
            if (this.pom.getBuild().getOutputDirectory() != null && (outputDirectoryFile = new File(this.pom.getBuild().getOutputDirectory())).exists()) {
                files.add(outputDirectoryFile);
            }
            return files;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new SonarException("Fail to create the project classloader", e);
        }
    }
}

