/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.duplications.index.ClonePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneGroup {
    private final ClonePart originPart;
    private final int cloneLength;
    private final List<ClonePart> parts;
    private int hash;
    private int length;

    public static Builder builder() {
        return new Builder();
    }

    private CloneGroup(Builder builder) {
        this.cloneLength = builder.length;
        this.originPart = builder.origin;
        this.parts = builder.parts;
        this.length = builder.lengthInUnits;
    }

    public ClonePart getOriginPart() {
        return this.originPart;
    }

    @Beta
    public int getLengthInUnits() {
        return this.length;
    }

    public int getCloneUnitLength() {
        return this.cloneLength;
    }

    public List<ClonePart> getCloneParts() {
        return this.parts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ClonePart part : this.parts) {
            builder.append(part).append(" - ");
        }
        builder.append(this.cloneLength);
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CloneGroup)) {
            return false;
        }
        CloneGroup another = (CloneGroup)object;
        if (another.cloneLength != this.cloneLength || this.parts.size() != another.parts.size()) {
            return false;
        }
        if (!this.originPart.equals(another.originPart)) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            result &= another.parts.get(i).equals(this.parts.get(i));
        }
        return result;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.cloneLength != 0) {
            for (ClonePart part : this.parts) {
                h = 31 * h + part.hashCode();
            }
            h = 31 * h + this.originPart.hashCode();
            this.hash = h = 31 * h + this.cloneLength;
        }
        return h;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private ClonePart origin;
        private int length;
        private int lengthInUnits;
        private List<ClonePart> parts;

        public Builder setLength(int length) {
            this.length = length;
            return this;
        }

        public Builder setOrigin(ClonePart origin) {
            this.origin = origin;
            return this;
        }

        public Builder setParts(List<ClonePart> parts) {
            this.parts = ImmutableList.copyOf(parts);
            return this;
        }

        public Builder setLengthInUnits(int length) {
            this.lengthInUnits = length;
            return this;
        }

        public CloneGroup build() {
            return new CloneGroup(this);
        }
    }
}

