/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FilenameFilter;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Tokenizer;

public abstract class AbstractLanguage
implements Language {
    private final Tokenizer tokenizer;
    private final FilenameFilter fileFilter;

    public AbstractLanguage(Tokenizer tokenizer, String ... extensions) {
        this.tokenizer = tokenizer;
        this.fileFilter = new ExtensionsFilter(extensions);
    }

    @Deprecated
    public FilenameFilter getFileFilter() {
        return this.fileFilter;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    private static class ExtensionsFilter
    implements FilenameFilter {
        private final String[] extensions;

        public ExtensionsFilter(String ... extensions) {
            this.extensions = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                this.extensions[i] = extensions[i].toUpperCase();
            }
        }

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            if (file.isDirectory()) {
                return true;
            }
            String uppercaseName = name.toUpperCase();
            for (String extension : this.extensions) {
                if (!uppercaseName.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

