/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

public class ClonePart {
    private final String resourceId;
    private final int unitStart;
    private final int lineStart;
    private final int lineEnd;
    private int hash;

    public ClonePart(String resourceId, int unitStart, int lineStart, int lineEnd) {
        this.resourceId = resourceId;
        this.unitStart = unitStart;
        this.lineStart = lineStart;
        this.lineEnd = lineEnd;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public int getUnitStart() {
        return this.unitStart;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public int getLines() {
        return this.lineEnd - this.lineStart + 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClonePart) {
            ClonePart another = (ClonePart)obj;
            return another.resourceId.equals(this.resourceId) && another.lineStart == this.lineStart && another.lineEnd == this.lineEnd && another.unitStart == this.unitStart;
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.resourceId.hashCode();
            h = 31 * h + this.lineStart;
            h = 31 * h + this.lineEnd;
            this.hash = h = 31 * h + this.unitStart;
        }
        return h;
    }

    public String toString() {
        return "'" + this.resourceId + "':[" + this.unitStart + "|" + this.lineStart + "-" + this.lineEnd + "]";
    }
}

