/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.original;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.utils.FastStringComparator;
import org.sonar.duplications.utils.SortedListsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Filter {
    private final List<CloneGroup> filtered = Lists.newLinkedList();
    private static final Comparator<ClonePart> RESOURCE_ID_COMPARATOR = new Comparator<ClonePart>(){

        @Override
        public int compare(ClonePart o1, ClonePart o2) {
            return FastStringComparator.INSTANCE.compare(o1.getResourceId(), o2.getResourceId());
        }
    };

    Filter() {
    }

    public List<CloneGroup> getResult() {
        return this.filtered;
    }

    public void add(CloneGroup current) {
        Iterator<CloneGroup> i = this.filtered.iterator();
        while (i.hasNext()) {
            CloneGroup earlier = i.next();
            if (Filter.containsIn(current, earlier)) {
                return;
            }
            if (!Filter.containsIn(earlier, current)) continue;
            i.remove();
        }
        this.filtered.add(current);
    }

    static boolean containsIn(CloneGroup first, CloneGroup second) {
        if (first.getCloneUnitLength() > second.getCloneUnitLength()) {
            return false;
        }
        List<ClonePart> firstParts = first.getCloneParts();
        List<ClonePart> secondParts = second.getCloneParts();
        return SortedListsUtils.contains(secondParts, firstParts, new ContainsInComparator(first.getCloneUnitLength(), second.getCloneUnitLength())) && SortedListsUtils.contains(firstParts, secondParts, RESOURCE_ID_COMPARATOR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContainsInComparator
    implements Comparator<ClonePart> {
        private final int l1;
        private final int l2;

        public ContainsInComparator(int l1, int l2) {
            this.l1 = l1;
            this.l2 = l2;
        }

        @Override
        public int compare(ClonePart o1, ClonePart o2) {
            int c = FastStringComparator.INSTANCE.compare(o1.getResourceId(), o2.getResourceId());
            if (c == 0) {
                if (o2.getUnitStart() <= o1.getUnitStart()) {
                    if (o1.getUnitStart() + this.l1 <= o2.getUnitStart() + this.l2) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
            return c;
        }
    }
}

