/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.purge;

import java.util.List;
import javax.persistence.Query;
import org.sonar.api.batch.Purge;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.MeasureData;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.database.model.SnapshotSource;
import org.sonar.api.design.DependencyDto;
import org.sonar.api.utils.TimeProfiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractPurge
implements Purge {
    private static final int MAX_IN_ELEMENTS = 950;
    private int sqlInPageSize = 950;
    private DatabaseSession session;
    private TimeProfiler profiler = new TimeProfiler().setLevelToDebug();

    public AbstractPurge(DatabaseSession session) {
        this.session = session;
    }

    protected DatabaseSession getSession() {
        return this.session;
    }

    protected void deleteSnapshotData(List<Integer> snapshotIds) {
        this.deleteMeasuresBySnapshotId(snapshotIds);
        this.deleteSources(snapshotIds);
        this.deleteViolations(snapshotIds);
        this.deleteDependencies(snapshotIds);
        this.deleteSnapshots(snapshotIds);
    }

    protected void deleteDependencies(List<Integer> snapshotIds) {
        this.executeQuery("delete dependencies", snapshotIds, "delete from " + DependencyDto.class.getSimpleName() + " d where d.fromSnapshotId in (:ids)");
        this.executeQuery("delete dependencies", snapshotIds, "delete from " + DependencyDto.class.getSimpleName() + " d where d.toSnapshotId in (:ids)");
    }

    protected void deleteMeasuresBySnapshotId(List<Integer> snapshotIds) {
        this.executeQuery("delete measures by snapshot id", snapshotIds, "delete from " + MeasureData.class.getSimpleName() + " m where m.snapshotId in (:ids)");
        this.executeQuery("delete measures by snapshot id", snapshotIds, "delete from " + MeasureModel.class.getSimpleName() + " m where m.snapshotId in (:ids)");
    }

    protected void deleteMeasuresById(List<Integer> measureIds) {
        this.executeQuery("delete measures by id", measureIds, "delete from " + MeasureData.class.getSimpleName() + " m where m.measure.id in (:ids)");
        this.executeQuery("delete measures by id", measureIds, "delete from " + MeasureModel.class.getSimpleName() + " m where m.id in (:ids)");
    }

    protected void deleteSources(List<Integer> snapshotIds) {
        this.executeQuery("delete sources", snapshotIds, "delete from " + SnapshotSource.class.getSimpleName() + " e where e.snapshotId in (:ids)");
    }

    protected void deleteViolations(List<Integer> snapshotIds) {
        this.executeQuery("delete violations", snapshotIds, "delete from " + RuleFailureModel.class.getSimpleName() + " e where e.snapshotId in (:ids)");
    }

    protected void deleteSnapshots(List<Integer> snapshotIds) {
        this.executeQuery("delete snapshots", snapshotIds, "delete from " + Snapshot.class.getSimpleName() + " s where s.id in (:ids)");
    }

    private void executeQuery(String name, List<Integer> ids, String hql) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        TimeProfiler profiler = new TimeProfiler().setLevelToDebug().start("Execute " + name);
        int page = 1;
        int index = 0;
        while (index < ids.size()) {
            TimeProfiler pageProfiler = new TimeProfiler().setLevelToDebug().start("Execute " + name + " " + page + " page");
            Query query = this.session.createQuery(hql);
            List<Integer> paginedSids = ids.subList(index, Math.min(ids.size(), index + this.sqlInPageSize));
            query.setParameter("ids", paginedSids);
            query.executeUpdate();
            index += this.sqlInPageSize;
            ++page;
            this.session.commit();
            pageProfiler.stop();
        }
        profiler.stop();
    }

    protected void executeQuery(List<Integer> ids, String hql) {
        this.executeQuery("delete for " + this.getClass().getSimpleName(), ids, hql);
    }

    protected List<Integer> selectIds(Query query) {
        this.profiler.start("Select IDs for " + this.getClass().getSimpleName());
        List result = query.getResultList();
        this.profiler.stop();
        return result;
    }
}

