/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.io.IOException;
import java.io.Reader;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.channel.CodeReaderFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelCodeReaderFilter<OUTPUT>
extends CodeReaderFilter<OUTPUT> {
    private Channel<OUTPUT>[] channels = new Channel[0];
    private CodeReader internalCodeReader;

    public ChannelCodeReaderFilter(Channel<OUTPUT> ... channels) {
        this.channels = channels;
    }

    public ChannelCodeReaderFilter(OUTPUT output, Channel<OUTPUT> ... channels) {
        super(output);
        this.channels = channels;
    }

    @Override
    public void setReader(Reader reader) {
        super.setReader(reader);
        this.internalCodeReader = new CodeReader(reader, this.getConfiguration());
    }

    @Override
    public int read(char[] filteredBuffer, int offset, int length) throws IOException {
        int initialOffset = offset;
        while (offset < filteredBuffer.length && this.internalCodeReader.peek() != -1) {
            boolean consumed = false;
            for (Channel channel : this.channels) {
                if (!channel.consume(this.internalCodeReader, this.getOutput())) continue;
                consumed = true;
                break;
            }
            if (consumed) continue;
            int charRead = this.internalCodeReader.pop();
            filteredBuffer[offset++] = (char)charRead;
        }
        return offset - initialOffset;
    }
}

