/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.sonar.channel.ChannelException;
import org.sonar.channel.EndMatcher;

public class CodeReader {
    private final Reader code;
    private int lastChar;
    private int linePosition;
    private int columnPosition;
    private int BUFFER_CAPACITY = 8000;
    private char[] buffer = new char[this.BUFFER_CAPACITY];
    private int buffer_position = 0;
    private int buffer_size = 0;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private boolean recordingMode = false;
    private StringBuilder recordedCharacters = new StringBuilder();

    public CodeReader(Reader code) {
        this.code = code;
        this.lastChar = -1;
        this.linePosition = 1;
        this.columnPosition = 0;
    }

    public CodeReader(String code) {
        this(new StringReader(code));
    }

    protected CodeReader(String code, int bufferCapacity) {
        this(new StringReader(code));
        this.BUFFER_CAPACITY = bufferCapacity;
        this.buffer = new char[this.BUFFER_CAPACITY];
    }

    public int pop() {
        int character;
        if (this.buffer_position == this.buffer_size) {
            this.fillBuffer();
        }
        if (this.buffer_size == 0) {
            return -1;
        }
        if ((character = this.buffer[this.buffer_position++]) == 10 || character == 13) {
            if (this.lastChar != 10 && this.lastChar != 13 || this.lastChar == character || this.lastChar == 10) {
                ++this.linePosition;
            }
            this.columnPosition = 0;
        } else {
            ++this.columnPosition;
        }
        if (this.recordingMode) {
            this.recordedCharacters.append((char)character);
        }
        this.lastChar = character;
        return character;
    }

    private int fillBuffer() {
        try {
            int offset = this.buffer_size - this.buffer_position;
            if (offset != 0) {
                System.arraycopy(this.buffer, this.buffer_position, this.buffer, 0, this.buffer_size - this.buffer_position);
            }
            this.buffer_position = 0;
            int numberOfChars = this.code.read(this.buffer, offset, this.BUFFER_CAPACITY - offset);
            if (numberOfChars == -1) {
                numberOfChars = 0;
            }
            this.buffer_size = numberOfChars + offset;
            return offset;
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage());
        }
    }

    public int lastChar() {
        return this.lastChar;
    }

    public int peek() {
        if (this.buffer_position >= this.buffer_size - 1) {
            this.fillBuffer();
        }
        if (this.buffer_size == 0) {
            return -1;
        }
        return this.buffer[this.buffer_position];
    }

    public void pop(Appendable appendable) {
        try {
            appendable.append((char)this.pop());
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage());
        }
    }

    public void close() {
        IOUtils.closeQuietly((Reader)this.code);
    }

    public char[] peek(int index) {
        char[] result = new char[index];
        if (this.buffer_position >= this.buffer_size - index) {
            this.fillBuffer();
        }
        System.arraycopy(this.buffer, this.buffer_position, result, 0, Math.min(index, this.buffer_size - this.buffer_position));
        return result;
    }

    public void peekTo(EndMatcher matcher, Appendable appendable) {
        if (this.buffer_position >= this.buffer_size - 1) {
            this.fillBuffer();
        }
        int tmp_buffer_position = this.buffer_position;
        int tmp_buffer_capacity = this.buffer_size - this.buffer_position;
        try {
            while (!matcher.match(this.buffer[tmp_buffer_position]) && this.buffer[tmp_buffer_position] != '\u0000') {
                appendable.append(this.buffer[tmp_buffer_position++]);
                if (--tmp_buffer_capacity > 0) continue;
                tmp_buffer_position -= this.buffer_position;
                this.fillBuffer();
            }
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage());
        }
    }

    public String peekTo(EndMatcher matcher) {
        StringBuilder sb = new StringBuilder();
        this.peekTo(matcher, sb);
        return sb.toString();
    }

    public void popTo(EndMatcher matcher, Appendable appendable) {
        try {
            do {
                appendable.append((char)this.pop());
            } while (!matcher.match(this.peek()) && this.peek() != -1);
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage());
        }
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public CodeReader setColumnPosition(int cp) {
        this.columnPosition = cp;
        return this;
    }

    public void setLinePosition(int lp) {
        this.linePosition = lp;
    }

    public void startRecording() {
        this.recordingMode = true;
    }

    public CharSequence stopRecording() {
        this.recordingMode = false;
        StringBuilder result = this.recordedCharacters;
        this.recordedCharacters = new StringBuilder();
        return result;
    }
}

