/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.resources.Project;
import org.sonar.api.task.TaskDefinition;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public class ExtensionInstaller
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionInstaller.class);
    private BatchPluginRepository pluginRepository;
    private EnvironmentInformation environment;
    private Settings settings;

    public ExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation environment, Settings settings) {
        this.pluginRepository = pluginRepository;
        this.environment = environment;
        this.settings = settings;
    }

    public void installTaskDefinitionExtensions(ComponentContainer container) {
        for (Map.Entry<PluginMetadata, Plugin> entry : this.pluginRepository.getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            container.addExtension(metadata, (Object)plugin);
            for (Object extension : plugin.getExtensions()) {
                this.installTaskDefinition(container, metadata, extension);
            }
        }
    }

    boolean installTaskDefinition(ComponentContainer container, @Nullable PluginMetadata plugin, Object extension) {
        boolean installed;
        if (ExtensionUtils.isType(extension, TaskDefinition.class) && ExtensionUtils.supportsEnvironment(extension, this.environment)) {
            LOG.debug("Installing task definition extension {} from plugin {}", (Object)extension.toString(), (Object)plugin.getKey());
            container.addExtension(plugin, extension);
            installed = true;
        } else {
            container.declareExtension(plugin, extension);
            installed = false;
        }
        return installed;
    }

    public void installTaskExtensions(ComponentContainer container, boolean projectPresent) {
        boolean dryRun = this.settings.getBoolean("sonar.dryRun");
        for (Map.Entry<PluginMetadata, Plugin> entry : this.pluginRepository.getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            container.addExtension(metadata, (Object)plugin);
            for (Object extension : plugin.getExtensions()) {
                this.installTaskExtension(container, metadata, extension, projectPresent);
                if (!projectPresent) continue;
                this.installBatchExtension(container, metadata, extension, dryRun, "PER_BATCH");
            }
        }
        List providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            this.executeTaskExtensionProvider(container, provider, projectPresent);
            if (!projectPresent) continue;
            this.executeBatchExtensionProvider(container, "PER_BATCH", dryRun, provider);
        }
    }

    private void executeTaskExtensionProvider(ComponentContainer container, ExtensionProvider provider, boolean projectPresent) {
        Object obj = provider.provide();
        if (obj instanceof Iterable) {
            for (Object extension : (Iterable)obj) {
                this.installTaskExtension(container, null, extension, projectPresent);
            }
        } else {
            this.installTaskExtension(container, null, obj, projectPresent);
        }
    }

    boolean installTaskExtension(ComponentContainer container, @Nullable PluginMetadata plugin, Object extension, boolean projectPresent) {
        boolean installed;
        if (ExtensionUtils.isTaskExtension(extension) && (projectPresent || !ExtensionUtils.requiresProject(extension)) && ExtensionUtils.supportsEnvironment(extension, this.environment)) {
            this.logInstallExtension("task", plugin, extension);
            container.addExtension(plugin, extension);
            installed = true;
        } else {
            container.declareExtension(plugin, extension);
            installed = false;
        }
        return installed;
    }

    public void installInspectionExtensions(ComponentContainer container) {
        this.installBatchExtensions(container, "PER_PROJECT");
    }

    @VisibleForTesting
    void installBatchExtensions(ComponentContainer container, String instantiationStrategy) {
        boolean dryRun = this.settings.getBoolean("sonar.dryRun");
        for (Map.Entry<PluginMetadata, Plugin> entry : this.pluginRepository.getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            container.addExtension(metadata, (Object)plugin);
            for (Object extension : plugin.getExtensions()) {
                this.installBatchExtension(container, metadata, extension, dryRun, instantiationStrategy);
            }
        }
        List providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            this.executeBatchExtensionProvider(container, instantiationStrategy, dryRun, provider);
        }
    }

    private void executeBatchExtensionProvider(ComponentContainer container, String instantiationStrategy, boolean dryRun, ExtensionProvider provider) {
        Object obj = provider.provide();
        if (obj instanceof Iterable) {
            for (Object extension : (Iterable)obj) {
                this.installBatchExtension(container, null, extension, dryRun, instantiationStrategy);
            }
        } else {
            this.installBatchExtension(container, null, obj, dryRun, instantiationStrategy);
        }
    }

    boolean installBatchExtension(ComponentContainer container, @Nullable PluginMetadata plugin, Object extension, boolean dryRun, String instantiationStrategy) {
        boolean installed;
        if (ExtensionUtils.isBatchExtension(extension) && ExtensionUtils.supportsEnvironment(extension, this.environment) && (!dryRun || ExtensionUtils.supportsDryRun(extension)) && ExtensionUtils.isInstantiationStrategy(extension, instantiationStrategy) && !ExtensionInstaller.isMavenExtensionOnEmulatedMavenProject(extension, instantiationStrategy, container)) {
            this.logInstallExtension("batch", plugin, extension);
            container.addExtension(plugin, extension);
            installed = true;
        } else {
            container.declareExtension(plugin, extension);
            installed = false;
        }
        return installed;
    }

    static boolean isMavenExtensionOnEmulatedMavenProject(Object extension, String instantiationStrategy, ComponentContainer container) {
        if ("PER_PROJECT".equals(instantiationStrategy) && ExtensionUtils.isMavenExtensionOnly(extension)) {
            Project project = (Project)container.getComponentByType(Project.class);
            return project != null && project.getPom() == null;
        }
        return false;
    }

    private void logInstallExtension(String extensionType, PluginMetadata plugin, Object extension) {
        if (plugin != null) {
            LOG.debug("Installing {} extension {} from plugin {}", (Object[])new String[]{extensionType, extension.toString(), plugin.getKey()});
        } else {
            LOG.debug("Installing {} extension {}", (Object)extensionType, (Object)extension.toString());
        }
    }
}

