/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.config.Logback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingConfiguration {
    public static final String PROPERTY_ROOT_LOGGER_LEVEL = "ROOT_LOGGER_LEVEL";
    public static final String PROPERTY_SQL_LOGGER_LEVEL = "SQL_LOGGER_LEVEL";
    public static final String PROPERTY_SQL_RESULTS_LOGGER_LEVEL = "SQL_RESULTS_LOGGER_LEVEL";
    public static final String PROPERTY_FORMAT = "FORMAT";
    public static final String LEVEL_ROOT_VERBOSE = "DEBUG";
    public static final String LEVEL_ROOT_DEFAULT = "INFO";
    public static final String LEVEL_SQL_VERBOSE = "DEBUG";
    public static final String LEVEL_SQL_DEFAULT = "WARN";
    public static final String LEVEL_SQL_RESULTS_VERBOSE = "DEBUG";
    public static final String LEVEL_SQL_RESULTS_DEFAULT = "WARN";
    public static final String FORMAT_DEFAULT = "%d{HH:mm:ss.SSS} %-5level - %msg%n";
    public static final String FORMAT_MAVEN = "[%level] [%d{HH:mm:ss.SSS}] %msg%n";
    private Map<String, String> substitutionVariables = Maps.newHashMap();

    private LoggingConfiguration() {
        this.setVerbose(false);
        this.setShowSql(false);
        this.setFormat(FORMAT_DEFAULT);
    }

    static LoggingConfiguration create() {
        return new LoggingConfiguration();
    }

    public LoggingConfiguration setProperties(Map<String, String> properties) {
        this.setShowSql("true".equals(properties.get("sonar.showSql")));
        this.setShowSqlResults("true".equals(properties.get("sonar.showSqlResults")));
        this.setVerbose("true".equals(properties.get("sonar.verbose")));
        return this;
    }

    public LoggingConfiguration setVerbose(boolean verbose) {
        return this.setRootLevel(verbose ? "DEBUG" : LEVEL_ROOT_DEFAULT);
    }

    public LoggingConfiguration setShowSql(boolean showSql) {
        return this.setSqlLevel(showSql ? "DEBUG" : "WARN");
    }

    public LoggingConfiguration setShowSqlResults(boolean showSqlResults) {
        return this.setSqlResultsLevel(showSqlResults ? "DEBUG" : "WARN");
    }

    public LoggingConfiguration setRootLevel(String level) {
        return this.addSubstitutionVariable(PROPERTY_ROOT_LOGGER_LEVEL, level);
    }

    public LoggingConfiguration setSqlLevel(String level) {
        return this.addSubstitutionVariable(PROPERTY_SQL_LOGGER_LEVEL, level);
    }

    public LoggingConfiguration setSqlResultsLevel(String level) {
        return this.addSubstitutionVariable(PROPERTY_SQL_RESULTS_LOGGER_LEVEL, level);
    }

    public LoggingConfiguration setFormat(String format) {
        return this.addSubstitutionVariable(PROPERTY_FORMAT, StringUtils.defaultIfBlank((String)format, (String)FORMAT_DEFAULT));
    }

    public LoggingConfiguration addSubstitutionVariable(String key, String value) {
        this.substitutionVariables.put(key, value);
        return this;
    }

    String getSubstitutionVariable(String key) {
        return this.substitutionVariables.get(key);
    }

    LoggingConfiguration configure(String classloaderPath) {
        Logback.configure((String)classloaderPath, this.substitutionVariables);
        return this;
    }

    LoggingConfiguration configure(File logbackFile) {
        Logback.configure((File)logbackFile, this.substitutionVariables);
        return this;
    }

    LoggingConfiguration configure() {
        Logback.configure((String)"/org/sonar/batch/bootstrapper/logback.xml", this.substitutionVariables);
        return this;
    }
}

