/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.BatchComponent;
import org.sonar.api.platform.Server;
import org.sonar.core.persistence.BadDatabaseVersion;
import org.sonar.core.persistence.DatabaseVersion;

public class DatabaseBatchCompatibility
implements BatchComponent {
    private DatabaseVersion version;
    private Server server;

    public DatabaseBatchCompatibility(DatabaseVersion version, Server server) {
        this.version = version;
        this.server = server;
    }

    public void start() {
        DatabaseVersion.Status status = this.version.getStatus();
        if (status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
            throw new BadDatabaseVersion("Database relates to a more recent version of Sonar. Please check your settings (JDBC settings, version of Maven plugin)");
        }
        if (status == DatabaseVersion.Status.REQUIRES_UPGRADE) {
            throw new BadDatabaseVersion("Database must be upgraded. Please browse " + this.server.getURL() + "/setup");
        }
        if (status != DatabaseVersion.Status.UP_TO_DATE) {
            throw new BadDatabaseVersion("Unknown database status: " + status);
        }
    }
}

