/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;

public class ServerMetadata
extends Server {
    private Settings settings;

    public ServerMetadata(Settings settings) {
        this.settings = settings;
    }

    public String getId() {
        return this.settings.getString("sonar.core.id");
    }

    public String getVersion() {
        return this.settings.getString("sonar.core.version");
    }

    public Date getStartedAt() {
        String dateString = this.settings.getString("sonar.core.startTime");
        if (dateString != null) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(dateString);
            }
            catch (ParseException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("The property sonar.core.startTime is badly formatted.", (Throwable)e);
            }
        }
        return null;
    }

    public String getURL() {
        return StringUtils.removeEnd((String)StringUtils.defaultIfBlank((String)this.settings.getString("sonar.host.url"), (String)"http://localhost:9000"), (String)"/");
    }

    public String getPermanentServerId() {
        return this.settings.getString("sonar.server_id");
    }
}

