/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Initializer;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.phases.SensorsExecutor;

public class InitializersExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SensorsExecutor.class);
    private MavenPluginExecutor mavenExecutor;
    private Collection<Initializer> initializers;
    private ProjectDefinition projectDef;
    private Project project;

    public InitializersExecutor(BatchExtensionDictionnary selector, Project project, ProjectDefinition projectDef, MavenPluginExecutor mavenExecutor) {
        this.initializers = selector.select(Initializer.class, project, true);
        this.mavenExecutor = mavenExecutor;
        this.project = project;
        this.projectDef = projectDef;
    }

    public void execute() {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializers : {}", (Object)StringUtils.join(this.initializers, (String)" -> "));
        }
        for (Initializer initializer : this.initializers) {
            this.executeMavenPlugin(initializer);
            TimeProfiler profiler = new TimeProfiler(logger).start("Initializer " + initializer);
            initializer.execute(this.project);
            profiler.stop();
        }
    }

    private void executeMavenPlugin(Initializer sensor) {
        MavenPluginHandler handler;
        if (sensor instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)sensor).getMavenPluginHandler(this.project)) != null) {
            TimeProfiler profiler = new TimeProfiler(logger).start("Execute maven plugin " + handler.getArtifactId());
            this.mavenExecutor.execute(this.project, this.projectDef, handler);
            profiler.stop();
        }
    }
}

