/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.platform.PluginRepository;
import org.sonar.batch.bootstrap.ArtifactDownloader;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.PluginClassloaders;
import org.sonar.core.plugins.PluginFileExtractor;
import org.sonar.core.plugins.RemotePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPluginRepository
implements PluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private static final String CORE_PLUGIN = "core";
    private ArtifactDownloader artifactDownloader;
    private Map<String, Plugin> pluginsByKey;
    private Map<String, PluginMetadata> metadataByKey;
    private Set<String> whiteList = null;
    private Set<String> blackList = null;
    private PluginClassloaders classLoaders;

    public BatchPluginRepository(ArtifactDownloader artifactDownloader, Settings settings) {
        this.artifactDownloader = artifactDownloader;
        if (settings.hasKey("sonar.includePlugins")) {
            this.whiteList = Sets.newTreeSet(Arrays.asList(settings.getStringArray("sonar.includePlugins")));
            LOG.info("Include plugins: " + Joiner.on((String)", ").join(this.whiteList));
        }
        if (settings.hasKey("sonar.excludePlugins")) {
            this.blackList = Sets.newTreeSet(Arrays.asList(settings.getStringArray("sonar.excludePlugins")));
            LOG.info("Exclude plugins: " + Joiner.on((String)", ").join(this.blackList));
        }
    }

    public void start() {
        this.doStart(this.artifactDownloader.downloadPluginIndex());
    }

    void doStart(List<RemotePlugin> remotePlugins) {
        PluginFileExtractor extractor = new PluginFileExtractor();
        this.metadataByKey = Maps.newHashMap();
        for (RemotePlugin remote : remotePlugins) {
            if (!this.isAccepted(remote.getKey())) continue;
            List<File> pluginFiles = this.artifactDownloader.downloadPlugin(remote);
            List<File> extensionFiles = pluginFiles.subList(1, pluginFiles.size());
            DefaultPluginMetadata metadata = extractor.installInSameLocation(pluginFiles.get(0), remote.isCore(), extensionFiles);
            if (!StringUtils.isBlank((String)metadata.getBasePlugin()) && !this.isAccepted(metadata.getBasePlugin())) continue;
            LOG.debug("Excluded plugin: " + metadata.getKey());
            this.metadataByKey.put(metadata.getKey(), (PluginMetadata)metadata);
        }
        this.classLoaders = new PluginClassloaders(Thread.currentThread().getContextClassLoader());
        this.pluginsByKey = this.classLoaders.init(this.metadataByKey.values());
    }

    public void stop() {
        if (this.classLoaders != null) {
            this.classLoaders.clean();
            this.classLoaders = null;
        }
    }

    public Collection<Plugin> getPlugins() {
        return this.pluginsByKey.values();
    }

    public Plugin getPlugin(String key) {
        return this.pluginsByKey.get(key);
    }

    public Map<String, Plugin> getPluginsByKey() {
        return Collections.unmodifiableMap(this.pluginsByKey);
    }

    public Property[] getProperties(Plugin plugin) {
        Class<?> classInstance;
        if (plugin != null && (classInstance = plugin.getClass()).isAnnotationPresent(Properties.class)) {
            return classInstance.getAnnotation(Properties.class).value();
        }
        return new Property[0];
    }

    public Collection<PluginMetadata> getMetadata() {
        return this.metadataByKey.values();
    }

    public PluginMetadata getMetadata(String pluginKey) {
        return this.metadataByKey.get(pluginKey);
    }

    boolean isAccepted(String pluginKey) {
        if (CORE_PLUGIN.equals(pluginKey)) {
            return true;
        }
        if (this.whiteList != null) {
            return this.whiteList.contains(pluginKey);
        }
        return this.blackList == null || !this.blackList.contains(pluginKey);
    }

    public Map<PluginMetadata, Plugin> getPluginsByMetadata() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, PluginMetadata> entry : this.metadataByKey.entrySet()) {
            String pluginKey = entry.getKey();
            PluginMetadata metadata = entry.getValue();
            result.put(metadata, this.pluginsByKey.get(pluginKey));
        }
        return result;
    }
}

