/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.phases.DecoratorsExecutor;
import org.sonar.batch.phases.InitializersExecutor;
import org.sonar.batch.phases.MavenPhaseExecutor;
import org.sonar.batch.phases.MavenPluginsConfigurator;
import org.sonar.batch.phases.PostJobsExecutor;
import org.sonar.batch.phases.ProjectAnalysisEvent;
import org.sonar.batch.phases.SensorsExecutor;
import org.sonar.batch.phases.UpdateStatusJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Phases {
    private EventBus eventBus;
    private DecoratorsExecutor decoratorsExecutor;
    private MavenPhaseExecutor mavenPhaseExecutor;
    private MavenPluginsConfigurator mavenPluginsConfigurator;
    private PostJobsExecutor postJobsExecutor;
    private InitializersExecutor initializersExecutor;
    private SensorsExecutor sensorsExecutor;
    private UpdateStatusJob updateStatusJob;
    private PersistenceManager persistenceManager;
    private SensorContext sensorContext;
    private DefaultIndex index;

    public static Collection<Class> getPhaseClasses(boolean dryRun) {
        ArrayList classes = Lists.newArrayList((Object[])new Class[]{DecoratorsExecutor.class, MavenPhaseExecutor.class, MavenPluginsConfigurator.class, PostJobsExecutor.class, SensorsExecutor.class, InitializersExecutor.class});
        if (!dryRun) {
            classes.add(UpdateStatusJob.class);
        }
        return classes;
    }

    public Phases(DecoratorsExecutor decoratorsExecutor, MavenPhaseExecutor mavenPhaseExecutor, MavenPluginsConfigurator mavenPluginsConfigurator, InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, PersistenceManager persistenceManager, SensorContext sensorContext, DefaultIndex index, EventBus eventBus, UpdateStatusJob updateStatusJob) {
        this.decoratorsExecutor = decoratorsExecutor;
        this.mavenPhaseExecutor = mavenPhaseExecutor;
        this.mavenPluginsConfigurator = mavenPluginsConfigurator;
        this.postJobsExecutor = postJobsExecutor;
        this.initializersExecutor = initializersExecutor;
        this.sensorsExecutor = sensorsExecutor;
        this.persistenceManager = persistenceManager;
        this.sensorContext = sensorContext;
        this.index = index;
        this.eventBus = eventBus;
        this.updateStatusJob = updateStatusJob;
    }

    public Phases(DecoratorsExecutor decoratorsExecutor, MavenPhaseExecutor mavenPhaseExecutor, MavenPluginsConfigurator mavenPluginsConfigurator, InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, PersistenceManager persistenceManager, SensorContext sensorContext, DefaultIndex index, EventBus eventBus) {
        this(decoratorsExecutor, mavenPhaseExecutor, mavenPluginsConfigurator, initializersExecutor, postJobsExecutor, sensorsExecutor, persistenceManager, sensorContext, index, eventBus, null);
    }

    public void execute(Project project) {
        this.eventBus.fireEvent(new ProjectAnalysisEvent(project, true));
        this.mavenPluginsConfigurator.execute(project);
        this.mavenPhaseExecutor.execute(project);
        this.initializersExecutor.execute();
        this.persistenceManager.setDelayedMode(true);
        this.sensorsExecutor.execute(this.sensorContext);
        this.decoratorsExecutor.execute();
        this.persistenceManager.dump();
        this.persistenceManager.setDelayedMode(false);
        if (project.isRoot()) {
            if (this.updateStatusJob != null) {
                this.updateStatusJob.execute();
            }
            this.postJobsExecutor.execute(this.sensorContext);
        }
        this.cleanMemory();
        this.eventBus.fireEvent(new ProjectAnalysisEvent(project, false));
    }

    private void cleanMemory() {
        this.persistenceManager.clear();
        this.index.clear();
    }
}

