/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import java.util.HashMap;
import java.util.Map;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Library;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.DefaultPersister;
import org.sonar.batch.indexer.LibraryPersister;
import org.sonar.batch.indexer.ProjectPersister;
import org.sonar.batch.indexer.ResourcePersister;

public final class ResourcePersisters {
    private Map<Class<? extends Resource>, ResourcePersister> persistersByClass;
    private ResourcePersister defaultPersister;

    public ResourcePersisters(DatabaseSession session) {
        this.defaultPersister = new DefaultPersister(session);
        this.persistersByClass = new HashMap<Class<? extends Resource>, ResourcePersister>();
        this.persistersByClass.put(Project.class, new ProjectPersister(session));
        this.persistersByClass.put(Library.class, new LibraryPersister(session));
    }

    public ResourcePersister get(Bucket bucket) {
        return this.get((Resource)bucket.getResource());
    }

    public ResourcePersister get(Resource resource) {
        ResourcePersister persister = this.persistersByClass.get(resource.getClass());
        return persister != null ? persister : this.defaultPersister;
    }
}

