/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.cdc.ComponentDescriptorWriter;
import org.codehaus.plexus.component.repository.cdc.ComponentDescriptor;
import org.codehaus.plexus.component.repository.cdc.ComponentSetDescriptor;
import org.codehaus.plexus.maven.plugin.ComponentDescriptorExtractor;
import org.codehaus.plexus.maven.plugin.SourceComponentDescriptorExtractor;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDescriptorMojo
extends AbstractMojo {
    protected static final String COMPILE_SCOPE = "compile";
    protected static final String TEST_SCOPE = "test";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String fileName;
    private boolean containerDescriptor;
    private MavenProject mavenProject;
    private ComponentDescriptor[] roleDefaults;
    private ComponentDescriptorExtractor[] extractors;
    private ComponentDescriptorWriter writer;
    private MavenProjectHelper mavenProjectHelper;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected MavenProjectHelper getMavenProjectHelper() {
        return this.mavenProjectHelper;
    }

    protected void generateDescriptor(String scope, File outputFile) throws MojoExecutionException {
        if (!$assertionsDisabled && scope == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputFile == null) {
            throw new AssertionError();
        }
        if (this.extractors == null || this.extractors.length == 0) {
            this.extractors = new ComponentDescriptorExtractor[]{new SourceComponentDescriptorExtractor()};
        }
        ArrayList descriptors = new ArrayList();
        for (int i = 0; i < this.extractors.length; ++i) {
            this.getLog().debug((CharSequence)("Using extractor: " + this.extractors[i]));
            try {
                List list = this.extractors[i].extract(this.getMavenProject(), scope, this.roleDefaults);
                if (list == null || list.isEmpty()) continue;
                descriptors.addAll(list);
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to extract descriptors", e);
            }
        }
        if (descriptors.size() == 0) {
            this.getLog().debug((CharSequence)"No components found");
        } else {
            this.getLog().info((CharSequence)("Discovered " + descriptors.size() + " component descriptors(s)"));
            ComponentSetDescriptor set = new ComponentSetDescriptor();
            set.setComponents(descriptors);
            set.setDependencies(Collections.EMPTY_LIST);
            try {
                this.writeDescriptor(set, outputFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to write output file", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor(ComponentSetDescriptor desc, File outputFile) throws Exception {
        if (!$assertionsDisabled && desc == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputFile == null) {
            throw new AssertionError();
        }
        FileUtils.forceMkdir((File)outputFile.getParentFile());
        BufferedWriter output = new BufferedWriter(new FileWriter(outputFile));
        try {
            this.writer.writeDescriptorSet((Writer)output, desc, this.containerDescriptor);
            output.flush();
        }
        finally {
            IOUtil.close((Writer)output);
        }
        this.getLog().debug((CharSequence)("Wrote: " + outputFile));
    }

    static {
        $assertionsDisabled = !AbstractDescriptorMojo.class.desiredAssertionStatus();
    }
}

